/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import org.apache.flink.datastream.api.context.RuntimeContext;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class ProcessOperator<IN, OUT>
extends AbstractUdfStreamOperator<OUT, OneInputStreamProcessFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    protected transient DefaultRuntimeContext context;
    protected transient DefaultNonPartitionedContext<OUT> nonPartitionedContext;
    protected transient TimestampCollector<OUT> outputCollector;

    public ProcessOperator(OneInputStreamProcessFunction<IN, OUT> userFunction) {
        super(userFunction);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.context = new DefaultRuntimeContext();
        this.nonPartitionedContext = new DefaultNonPartitionedContext();
        this.outputCollector = this.getOutputCollector();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.outputCollector.setTimestampFromStreamRecord(element);
        ((OneInputStreamProcessFunction)this.userFunction).processRecord(element.getValue(), this.outputCollector, (RuntimeContext)this.context);
    }

    protected TimestampCollector<OUT> getOutputCollector() {
        return new OutputCollector(this.output);
    }

    public void endInput() throws Exception {
        ((OneInputStreamProcessFunction)this.userFunction).endInput(this.nonPartitionedContext);
    }
}

