/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.junit.extensions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.testframe.environment.ClusterControllable;
import org.apache.flink.connector.testframe.environment.TestEnvironment;
import org.apache.flink.connector.testframe.external.ExternalContext;
import org.apache.flink.connector.testframe.junit.extensions.ConnectorTestingExtension;
import org.apache.flink.core.execution.CheckpointingMode;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

@Internal
public class TestCaseInvocationContextProvider
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return Arrays.stream(context.getRequiredTestMethod().getParameterTypes()).anyMatch(type -> TestEnvironment.class.isAssignableFrom((Class<?>)type) || ExternalContext.class.isAssignableFrom((Class<?>)type));
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        TestEnvironment testEnv = (TestEnvironment)context.getStore(ConnectorTestingExtension.TEST_RESOURCE_NAMESPACE).get((Object)"testEnvironment", TestEnvironment.class);
        List externalContextFactories = (List)context.getStore(ConnectorTestingExtension.TEST_RESOURCE_NAMESPACE).get((Object)"externalContext");
        CheckpointingMode[] semantics = (CheckpointingMode[])context.getStore(ConnectorTestingExtension.TEST_RESOURCE_NAMESPACE).get((Object)"supportedSemantic");
        return externalContextFactories.stream().flatMap(factory -> {
            LinkedList<TestResourceProvidingInvocationContext> result = new LinkedList<TestResourceProvidingInvocationContext>();
            for (CheckpointingMode semantic : semantics) {
                result.add(new TestResourceProvidingInvocationContext(testEnv, (ExternalContext)factory.createExternalContext(context.getDisplayName()), semantic));
            }
            return result.stream();
        });
    }

    private static boolean isAssignableFromParameterType(Class<?> requiredType, Class<?> parameterType) {
        return requiredType.isAssignableFrom(parameterType);
    }

    private static class ClusterControllableProvider
    implements ParameterResolver {
        private final TestEnvironment testEnvironment;

        private ClusterControllableProvider(TestEnvironment testEnvironment) {
            this.testEnvironment = testEnvironment;
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return TestCaseInvocationContextProvider.isAssignableFromParameterType(ClusterControllable.class, parameterContext.getParameter().getType()) && this.isTestEnvironmentControllable(this.testEnvironment);
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.testEnvironment;
        }

        private boolean isTestEnvironmentControllable(TestEnvironment testEnvironment) {
            return ClusterControllable.class.isAssignableFrom(testEnvironment.getClass());
        }
    }

    private static class ExternalContextProvider
    implements ParameterResolver {
        private final ExternalContext externalContext;

        private ExternalContextProvider(ExternalContext externalContext) {
            this.externalContext = externalContext;
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return TestCaseInvocationContextProvider.isAssignableFromParameterType(ExternalContext.class, parameterContext.getParameter().getType());
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.externalContext;
        }
    }

    private static class TestEnvironmentResolver
    implements ParameterResolver {
        private final TestEnvironment testEnvironment;

        private TestEnvironmentResolver(TestEnvironment testEnvironment) {
            this.testEnvironment = testEnvironment;
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return TestCaseInvocationContextProvider.isAssignableFromParameterType(TestEnvironment.class, parameterContext.getParameter().getType());
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.testEnvironment;
        }
    }

    private static class SemanticResolver
    implements ParameterResolver {
        private final CheckpointingMode semantic;

        private SemanticResolver(CheckpointingMode semantic) {
            this.semantic = semantic;
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return TestCaseInvocationContextProvider.isAssignableFromParameterType(CheckpointingMode.class, parameterContext.getParameter().getType());
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.semantic;
        }
    }

    static class TestResourceProvidingInvocationContext
    implements TestTemplateInvocationContext {
        private final TestEnvironment testEnvironment;
        private final ExternalContext externalContext;
        private final CheckpointingMode semantic;

        public TestResourceProvidingInvocationContext(TestEnvironment testEnvironment, ExternalContext externalContext, CheckpointingMode semantic) {
            this.testEnvironment = testEnvironment;
            this.externalContext = externalContext;
            this.semantic = semantic;
        }

        public String getDisplayName(int invocationIndex) {
            return String.format("TestEnvironment: [%s], ExternalContext: [%s], Semantic: [%s]", this.testEnvironment, this.externalContext, this.semantic);
        }

        public List<Extension> getAdditionalExtensions() {
            return Arrays.asList(new TestEnvironmentResolver(this.testEnvironment), new ExternalContextProvider(this.externalContext), new ClusterControllableProvider(this.testEnvironment), new SemanticResolver(this.semantic), ignore -> this.externalContext.close());
        }
    }
}

