/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.external.source;

import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.util.Preconditions;

public class TestingSourceSettings {
    private final Boundedness boundedness;
    private final org.apache.flink.core.execution.CheckpointingMode checkpointingMode;

    public static Builder builder() {
        return new Builder();
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    @Deprecated
    public CheckpointingMode getCheckpointingMode() {
        return CheckpointingMode.convertFromCheckpointingMode((org.apache.flink.core.execution.CheckpointingMode)this.checkpointingMode);
    }

    private TestingSourceSettings(Boundedness boundedness, org.apache.flink.core.execution.CheckpointingMode checkpointingMode) {
        this.boundedness = boundedness;
        this.checkpointingMode = checkpointingMode;
    }

    public static class Builder {
        private Boundedness boundedness;
        private org.apache.flink.core.execution.CheckpointingMode checkpointingMode = org.apache.flink.core.execution.CheckpointingMode.EXACTLY_ONCE;

        public Builder setBoundedness(Boundedness boundedness) {
            this.boundedness = boundedness;
            return this;
        }

        public Builder setCheckpointingMode(org.apache.flink.core.execution.CheckpointingMode checkpointingMode) {
            this.checkpointingMode = checkpointingMode;
            return this;
        }

        @Deprecated
        public Builder setCheckpointingMode(CheckpointingMode checkpointingMode) {
            this.checkpointingMode = CheckpointingMode.convertToCheckpointingMode((CheckpointingMode)checkpointingMode);
            return this;
        }

        public TestingSourceSettings build() {
            this.sanityCheck();
            return new TestingSourceSettings(this.boundedness, this.checkpointingMode);
        }

        private void sanityCheck() {
            Preconditions.checkNotNull((Object)this.boundedness, (String)"Boundedness is not specified");
            Preconditions.checkNotNull((Object)this.checkpointingMode, (String)"Checkpointing mode is not specified");
        }
    }
}

