/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.container;

import com.github.dockerjava.api.exception.NotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.connector.testframe.container.FlinkContainersSettings;
import org.apache.flink.connector.testframe.container.ImageBuildException;
import org.apache.flink.test.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class FlinkImageBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkImageBuilder.class);
    private static final String FLINK_BASE_IMAGE_BUILD_NAME = "flink-base";
    private static final String DEFAULT_IMAGE_NAME_BUILD_PREFIX = "flink-configured";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(5L);
    private static final String LOG4J_PROPERTIES_FILENAME = "log4j-console.properties";
    private final Map<Path, Path> filesToCopy = new HashMap<Path, Path>();
    private final Properties logProperties = new Properties();
    private Path tempDirectory;
    private String imageNamePrefix = "flink-configured";
    private String imageNameSuffix;
    private Path flinkDist;
    private String javaVersion;
    private Configuration conf;
    private Duration timeout = DEFAULT_TIMEOUT;
    private String startupCommand;
    private String baseImage;
    private String flinkHome = FlinkContainersSettings.getDefaultFlinkHome();

    public FlinkImageBuilder setTempDirectory(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        return this;
    }

    public FlinkImageBuilder setFlinkHome(String flinkHome) {
        this.flinkHome = flinkHome;
        return this;
    }

    public FlinkImageBuilder setImageNamePrefix(String imageNamePrefix) {
        this.imageNamePrefix = imageNamePrefix;
        return this;
    }

    public FlinkImageBuilder setFlinkDistPath(Path flinkDist) {
        this.flinkDist = flinkDist;
        return this;
    }

    public FlinkImageBuilder setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    public FlinkImageBuilder setConfiguration(Configuration conf) {
        this.conf = conf;
        return this;
    }

    public FlinkImageBuilder setLogProperties(Properties logProperties) {
        this.logProperties.putAll((Map<?, ?>)logProperties);
        return this;
    }

    public FlinkImageBuilder copyFile(Path localPath, Path containerPath) {
        this.filesToCopy.put(localPath, containerPath);
        return this;
    }

    public FlinkImageBuilder setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public FlinkImageBuilder asJobManager() {
        this.checkStartupCommandNotSet();
        this.startupCommand = "bin/jobmanager.sh start-foreground && tail -f /dev/null";
        this.imageNameSuffix = "jobmanager";
        return this;
    }

    public FlinkImageBuilder asTaskManager() {
        this.checkStartupCommandNotSet();
        this.startupCommand = "bin/taskmanager.sh start-foreground && tail -f /dev/null";
        this.imageNameSuffix = "taskmanager";
        return this;
    }

    public FlinkImageBuilder useCustomStartupCommand(String command) {
        this.checkStartupCommandNotSet();
        this.startupCommand = command;
        this.imageNameSuffix = "custom";
        return this;
    }

    public FlinkImageBuilder setBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return this;
    }

    public ImageFromDockerfile build() throws ImageBuildException {
        this.sanityCheck();
        String finalImageName = this.imageNamePrefix + "-" + this.imageNameSuffix;
        try {
            if (this.baseImage == null) {
                this.baseImage = FLINK_BASE_IMAGE_BUILD_NAME;
                if (this.flinkDist == null) {
                    this.flinkDist = FileUtils.findFlinkDist();
                }
                this.buildBaseImage(this.flinkDist);
            }
            Path flinkConfFile = this.createTemporaryFlinkConfFile(this.conf, this.tempDirectory);
            Path log4jPropertiesFile = this.createTemporaryLog4jPropertiesFile(this.tempDirectory);
            this.filesToCopy.put(flinkConfFile, Paths.get(this.flinkHome, "conf", "config.yaml"));
            this.filesToCopy.put(log4jPropertiesFile, Paths.get(this.flinkHome, "conf", LOG4J_PROPERTIES_FILENAME));
            ImageFromDockerfile image = (ImageFromDockerfile)new ImageFromDockerfile(finalImageName).withDockerfileFromBuilder(builder -> {
                builder.from(this.baseImage);
                this.filesToCopy.forEach((from, to) -> builder.copy(to.toString(), to.toString()));
                builder.cmd(this.startupCommand);
            });
            this.filesToCopy.forEach((from, to) -> image.withFileFromPath(to.toString(), from));
            return image;
        }
        catch (Exception e) {
            throw new ImageBuildException(finalImageName, e);
        }
    }

    private void buildBaseImage(Path flinkDist) throws TimeoutException {
        if (this.baseImageExists()) {
            return;
        }
        LOG.info("Building Flink base image with flink-dist at {}", (Object)flinkDist);
        ((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile(FLINK_BASE_IMAGE_BUILD_NAME).withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)builder.from("eclipse-temurin:" + this.getJavaVersionSuffix() + "-jre-jammy")).copy(this.flinkHome, this.flinkHome)).build())).withFileFromPath(this.flinkHome, flinkDist)).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private boolean baseImageExists() {
        try {
            DockerClientFactory.instance().client().inspectImageCmd(FLINK_BASE_IMAGE_BUILD_NAME).exec();
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private String getJavaVersionSuffix() {
        if (this.javaVersion != null) {
            return this.javaVersion;
        }
        String javaSpecVersion = System.getProperty("java.vm.specification.version");
        LOG.info("Using JDK version {} of the current VM", (Object)javaSpecVersion);
        switch (javaSpecVersion) {
            case "1.8": {
                return "8";
            }
            case "11": {
                return "11";
            }
            case "17": {
                return "17";
            }
            case "21": {
                return "21";
            }
        }
        throw new IllegalStateException("Unexpected Java version: " + javaSpecVersion);
    }

    private Path createTemporaryFlinkConfFile(Configuration finalConfiguration, Path tempDirectory) throws IOException {
        Path flinkConfFile = tempDirectory.resolve("config.yaml");
        Files.write(flinkConfFile, (Iterable<? extends CharSequence>)ConfigurationUtils.convertConfigToWritableLines((Configuration)finalConfiguration, (boolean)false), new OpenOption[0]);
        return flinkConfFile;
    }

    private Path createTemporaryLog4jPropertiesFile(Path tempDirectory) throws IOException {
        Path log4jPropFile = tempDirectory.resolve(LOG4J_PROPERTIES_FILENAME);
        try (FileOutputStream output = new FileOutputStream(log4jPropFile.toFile());){
            this.logProperties.store(output, null);
        }
        return log4jPropFile;
    }

    private void checkStartupCommandNotSet() {
        if (this.startupCommand != null) {
            throw new IllegalStateException("Cannot set startup command of container multiple times");
        }
    }

    private void sanityCheck() {
        Preconditions.checkNotNull((Object)this.tempDirectory, (String)"Temporary path is not specified");
        Preconditions.checkState((boolean)Files.isDirectory(this.tempDirectory, new LinkOption[0]));
        Preconditions.checkNotNull((Object)this.startupCommand, (String)"JobManager or TaskManager is not specified for the image");
    }
}

