/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.junit.extensions;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.testframe.TestResource;
import org.apache.flink.connector.testframe.environment.TestEnvironment;
import org.apache.flink.connector.testframe.external.ExternalContextFactory;
import org.apache.flink.connector.testframe.junit.annotations.TestContext;
import org.apache.flink.connector.testframe.junit.annotations.TestEnv;
import org.apache.flink.connector.testframe.junit.annotations.TestExternalSystem;
import org.apache.flink.connector.testframe.junit.annotations.TestSemantics;
import org.apache.flink.core.execution.CheckpointingMode;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

@Internal
public class ConnectorTestingExtension
implements BeforeAllCallback,
AfterAllCallback {
    public static final ExtensionContext.Namespace TEST_RESOURCE_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"testResourceNamespace"});
    public static final String TEST_ENV_STORE_KEY = "testEnvironment";
    public static final String EXTERNAL_SYSTEM_STORE_KEY = "externalSystem";
    public static final String EXTERNAL_CONTEXT_FACTORIES_STORE_KEY = "externalContext";
    public static final String SUPPORTED_SEMANTIC_STORE_KEY = "supportedSemantic";
    private TestEnvironment testEnvironment;
    private TestResource externalSystem;

    public void beforeAll(ExtensionContext context) throws Exception {
        List testEnvironments = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), TestEnv.class, TestEnvironment.class);
        this.checkExactlyOneAnnotatedField(testEnvironments, TestEnv.class);
        this.testEnvironment = (TestEnvironment)testEnvironments.get(0);
        this.testEnvironment.startUp();
        context.getStore(TEST_RESOURCE_NAMESPACE).put((Object)TEST_ENV_STORE_KEY, (Object)this.testEnvironment);
        List<TestResource> externalSystems = this.findAnnotatedFieldValues(context, TestExternalSystem.class, TestResource.class);
        if (!externalSystems.isEmpty()) {
            this.externalSystem = externalSystems.get(0);
            this.externalSystem.startUp();
            context.getStore(TEST_RESOURCE_NAMESPACE).put((Object)EXTERNAL_SYSTEM_STORE_KEY, (Object)this.externalSystem);
        }
        ArrayList<A[]> semantics = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), TestSemantics.class, CheckpointingMode[].class);
        List fallbackSemantics = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), TestSemantics.class, org.apache.flink.streaming.api.CheckpointingMode[].class);
        if (!fallbackSemantics.isEmpty()) {
            semantics = new ArrayList<A[]>(semantics);
        }
        for (org.apache.flink.streaming.api.CheckpointingMode[] oldModes : fallbackSemantics) {
            semantics.add(((Stream)Arrays.stream(oldModes).sequential()).map(org.apache.flink.streaming.api.CheckpointingMode::convertToCheckpointingMode).toArray(CheckpointingMode[]::new));
        }
        this.checkExactlyOneAnnotatedField(semantics, TestSemantics.class);
        context.getStore(TEST_RESOURCE_NAMESPACE).put((Object)SUPPORTED_SEMANTIC_STORE_KEY, semantics.get(0));
        List externalContextFactories = AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), TestContext.class, ExternalContextFactory.class);
        this.checkAtLeastOneAnnotationField(externalContextFactories, TestContext.class);
        context.getStore(TEST_RESOURCE_NAMESPACE).put((Object)EXTERNAL_CONTEXT_FACTORIES_STORE_KEY, (Object)externalContextFactories);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.testEnvironment.tearDown();
        if (this.externalSystem != null) {
            this.externalSystem.tearDown();
        }
        context.getStore(TEST_RESOURCE_NAMESPACE).remove((Object)TEST_ENV_STORE_KEY);
        context.getStore(TEST_RESOURCE_NAMESPACE).remove((Object)EXTERNAL_SYSTEM_STORE_KEY);
        context.getStore(TEST_RESOURCE_NAMESPACE).remove((Object)EXTERNAL_CONTEXT_FACTORIES_STORE_KEY);
    }

    private <T> List<T> findAnnotatedFieldValues(ExtensionContext context, Class<? extends Annotation> annotationType, Class<T> fieldType) {
        ArrayList fields = new ArrayList();
        fields.addAll(AnnotationSupport.findAnnotatedFieldValues((Object)context.getRequiredTestInstance(), annotationType, fieldType));
        fields.addAll(AnnotationSupport.findAnnotatedFieldValues((Class)context.getRequiredTestClass(), annotationType, fieldType));
        return fields;
    }

    private void checkExactlyOneAnnotatedField(Collection<?> fields, Class<? extends Annotation> annotation) {
        if (fields.size() > 1) {
            throw new IllegalStateException(String.format("Multiple fields are annotated with '@%s'", annotation.getSimpleName()));
        }
        if (fields.isEmpty()) {
            throw new IllegalStateException(String.format("No fields are annotated with '@%s'", annotation.getSimpleName()));
        }
    }

    private void checkAtLeastOneAnnotationField(Collection<?> fields, Class<? extends Annotation> annotation) {
        if (fields.isEmpty()) {
            throw new IllegalStateException(String.format("No fields are annotated with '@%s'", annotation.getSimpleName()));
        }
    }
}

