/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnector;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.sqlserver.SqlServerValidator;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.cdc.debezium.Validator;
import org.apache.flink.util.Preconditions;

@Deprecated
public class SqlServerSource {
    private static final String DATABASE_SERVER_NAME = "sqlserver_transaction_log_source";

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private int port = 1433;
        private String hostname;
        private String database;
        private String username;
        private String password;
        private String[] tableList;
        private Properties dbzProperties;
        private StartupOptions startupOptions = StartupOptions.initial();
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> database(String database) {
            this.database = database;
            return this;
        }

        public Builder<T> tableList(String ... tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> debeziumProperties(Properties properties) {
            this.dbzProperties = properties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> startupOptions(StartupOptions startupOptions) {
            this.startupOptions = startupOptions;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", SqlServerConnector.class.getCanonicalName());
            props.setProperty("database.server.name", SqlServerSource.DATABASE_SERVER_NAME);
            props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
            props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
            props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
            props.setProperty("database.port", String.valueOf(this.port));
            props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
            props.setProperty("database.dbname", (String)Preconditions.checkNotNull((Object)this.database));
            if (this.tableList != null) {
                props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
            }
            switch (this.startupOptions.startupMode) {
                case INITIAL: {
                    props.setProperty("snapshot.mode", "initial");
                    break;
                }
                case LATEST_OFFSET: {
                    props.setProperty("snapshot.mode", "schema_only");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.dbzProperties != null) {
                props.putAll((Map<?, ?>)this.dbzProperties);
            }
            return new DebeziumSourceFunction(this.deserializer, props, null, (Validator)new SqlServerValidator(props));
        }
    }
}

