/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import org.apache.flink.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import org.apache.flink.cdc.connectors.base.source.meta.split.SnapshotSplit;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.apache.flink.cdc.connectors.base.source.reader.external.AbstractScanFetchTask;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerSourceFetchTaskContext;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerStreamFetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.utils.SqlServerUtils;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerScanFetchTask
extends AbstractScanFetchTask {
    public SqlServerScanFetchTask(SnapshotSplit split) {
        super(split);
    }

    protected void executeDataSnapshot(FetchTask.Context context) throws Exception {
        SqlServerSnapshotSplitChangeEventSourceContext changeEventSourceContext;
        SqlServerSourceFetchTaskContext sourceFetchContext = (SqlServerSourceFetchTaskContext)context;
        this.taskRunning = true;
        SqlServerSnapshotSplitReadTask snapshotSplitReadTask = new SqlServerSnapshotSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getOffsetContext(), (SnapshotProgressListener<SqlServerPartition>)sourceFetchContext.getSnapshotChangeEventSourceMetrics(), sourceFetchContext.getDatabaseSchema(), sourceFetchContext.getConnection(), sourceFetchContext.getDispatcher(), sourceFetchContext.getSnapshotReceiver(), this.snapshotSplit);
        SnapshotResult<SqlServerOffsetContext> snapshotResult = snapshotSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)(changeEventSourceContext = new SqlServerSnapshotSplitChangeEventSourceContext()), sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
        if (!snapshotResult.isCompletedOrSkipped()) {
            this.taskRunning = false;
            throw new IllegalStateException(String.format("Read snapshot for SqlServer split %s fail", this.snapshotSplit));
        }
    }

    protected void executeBackfillTask(FetchTask.Context context, StreamSplit backfillStreamSplit) throws Exception {
        SqlServerSourceFetchTaskContext sourceFetchContext = (SqlServerSourceFetchTaskContext)context;
        SqlServerOffsetContext.Loader loader = new SqlServerOffsetContext.Loader(sourceFetchContext.getDbzConnectorConfig());
        SqlServerOffsetContext streamOffsetContext = loader.load(backfillStreamSplit.getStartingOffset().getOffset());
        SqlServerStreamFetchTask.StreamSplitReadTask backfillBinlogReadTask = this.createBackFillLsnSplitReadTask(backfillStreamSplit, sourceFetchContext);
        backfillBinlogReadTask.execute((ChangeEventSource.ChangeEventSourceContext)new SqlServerSnapshotSplitChangeEventSourceContext(), sourceFetchContext.getPartition(), streamOffsetContext);
    }

    private SqlServerStreamFetchTask.StreamSplitReadTask createBackFillLsnSplitReadTask(StreamSplit backfillBinlogSplit, SqlServerSourceFetchTaskContext context) {
        Configuration dezConf = ((Configuration.Builder)((Configuration.Builder)context.getDbzConnectorConfig().getConfig().edit().with("table.include.list", (Object)new TableId(null, this.snapshotSplit.getTableId().schema(), this.snapshotSplit.getTableId().table()))).with(Heartbeat.HEARTBEAT_INTERVAL, 0)).build();
        return new SqlServerStreamFetchTask.StreamSplitReadTask(new SqlServerConnectorConfig(dezConf), context.getConnection(), context.getMetaDataConnection(), context.getDispatcher(), context.getErrorHandler(), context.getDatabaseSchema(), backfillBinlogSplit);
    }

    public class SqlServerSnapshotSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        public void finished() {
            SqlServerScanFetchTask.this.taskRunning = false;
        }

        public boolean isRunning() {
            return SqlServerScanFetchTask.this.taskRunning;
        }
    }

    public static class SqlServerSnapshotSplitReadTask
    extends AbstractSnapshotChangeEventSource<SqlServerPartition, SqlServerOffsetContext> {
        private static final Logger LOG = LoggerFactory.getLogger(SqlServerSnapshotSplitReadTask.class);
        private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
        private final SqlServerConnectorConfig connectorConfig;
        private final SqlServerDatabaseSchema databaseSchema;
        private final SqlServerConnection jdbcConnection;
        private final JdbcSourceEventDispatcher<SqlServerPartition> dispatcher;
        private final Clock clock;
        private final SnapshotSplit snapshotSplit;
        private final SqlServerOffsetContext offsetContext;
        private final SnapshotProgressListener<SqlServerPartition> snapshotProgressListener;
        private final EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver;

        public SqlServerSnapshotSplitReadTask(SqlServerConnectorConfig connectorConfig, SqlServerOffsetContext previousOffset, SnapshotProgressListener<SqlServerPartition> snapshotProgressListener, SqlServerDatabaseSchema databaseSchema, SqlServerConnection jdbcConnection, JdbcSourceEventDispatcher<SqlServerPartition> dispatcher, EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver, SnapshotSplit snapshotSplit) {
            super((CommonConnectorConfig)connectorConfig, snapshotProgressListener);
            this.offsetContext = previousOffset;
            this.connectorConfig = connectorConfig;
            this.databaseSchema = databaseSchema;
            this.jdbcConnection = jdbcConnection;
            this.dispatcher = dispatcher;
            this.clock = Clock.SYSTEM;
            this.snapshotSplit = snapshotSplit;
            this.snapshotProgressListener = snapshotProgressListener;
            this.snapshotReceiver = snapshotReceiver;
        }

        public SnapshotResult<SqlServerOffsetContext> execute(ChangeEventSource.ChangeEventSourceContext context, SqlServerPartition partition, SqlServerOffsetContext previousOffset) throws InterruptedException {
            SqlServerSnapshotContext ctx;
            AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(partition, previousOffset);
            try {
                ctx = this.prepare(partition);
            }
            catch (Exception e) {
                LOG.error("Failed to initialize snapshot context.", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return this.doExecute(context, previousOffset, (AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext>)ctx, snapshottingTask);
            }
            catch (InterruptedException e) {
                LOG.warn("Snapshot was interrupted before completion");
                throw e;
            }
            catch (Exception t) {
                throw new DebeziumException((Throwable)t);
            }
        }

        protected SnapshotResult<SqlServerOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, SqlServerOffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
            SqlServerSnapshotContext ctx = (SqlServerSnapshotContext)snapshotContext;
            ctx.offset = this.offsetContext;
            LOG.info("Snapshot step 2 - Snapshotting data");
            this.createDataEvents(ctx, this.snapshotSplit.getTableId());
            return SnapshotResult.completed((OffsetContext)ctx.offset);
        }

        protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(SqlServerPartition partition, SqlServerOffsetContext previousOffset) {
            return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
        }

        protected SqlServerSnapshotContext prepare(SqlServerPartition partition) throws Exception {
            return new SqlServerSnapshotContext(partition);
        }

        private void createDataEvents(SqlServerSnapshotContext snapshotContext, TableId tableId) throws Exception {
            LOG.debug("Snapshotting table {}", (Object)tableId);
            this.createDataEventsForTable(snapshotContext, this.snapshotReceiver, this.databaseSchema.tableFor(tableId));
            this.snapshotReceiver.completeSnapshot();
        }

        private void createDataEventsForTable(SqlServerSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver, Table table) throws InterruptedException {
            long exportStart = this.clock.currentTimeInMillis();
            LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
            String selectSql = SqlServerUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
            LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
            try (PreparedStatement selectStatement = SqlServerUtils.readTableSplitDataStatement((JdbcConnection)this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, this.snapshotSplit.getSplitStart(), this.snapshotSplit.getSplitEnd(), this.snapshotSplit.getSplitKeyType().getFieldCount(), this.connectorConfig.getQueryFetchSize());
                 ResultSet rs = selectStatement.executeQuery();){
                ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray((ResultSet)rs, (Table)table);
                long rows = 0L;
                Threads.Timer logTimer = this.getTableScanLogTimer();
                while (rs.next()) {
                    ++rows;
                    Object[] row = this.jdbcConnection.rowToArray(table, (DatabaseSchema)this.databaseSchema, rs, columnArray);
                    if (logTimer.expired()) {
                        long stop = this.clock.currentTimeInMillis();
                        LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration((long)(stop - exportStart))});
                        this.snapshotProgressListener.rowsScanned(snapshotContext.partition, table.id(), rows);
                        logTimer = this.getTableScanLogTimer();
                    }
                    this.dispatcher.dispatchSnapshotEvent(snapshotContext.partition, (DataCollectionId)table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
                }
                LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration((long)(this.clock.currentTimeInMillis() - exportStart))});
            }
            catch (SQLException e) {
                throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
            }
        }

        protected ChangeRecordEmitter<SqlServerPartition> getChangeRecordEmitter(SqlServerSnapshotContext snapshotContext, TableId tableId, Object[] row) {
            ((SqlServerOffsetContext)snapshotContext.offset).event((DataCollectionId)tableId, this.clock.currentTime());
            return new SnapshotChangeRecordEmitter(snapshotContext.partition, snapshotContext.offset, row, this.clock);
        }

        private Threads.Timer getTableScanLogTimer() {
            return Threads.timer((Clock)this.clock, (Duration)LOG_INTERVAL);
        }

        private static class SqlServerSnapshotContext
        extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> {
            public SqlServerSnapshotContext(SqlServerPartition partition) throws SQLException {
                super((Partition)partition, "");
            }
        }
    }
}

