/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.table;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.base.options.JdbcSourceOptions;
import org.apache.flink.cdc.connectors.base.options.SourceOptions;
import org.apache.flink.cdc.connectors.base.options.StartupMode;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.utils.ObjectUtils;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceOptions;
import org.apache.flink.cdc.connectors.postgres.table.PostgreSQLTableSource;
import org.apache.flink.cdc.connectors.postgres.utils.OptionUtils;
import org.apache.flink.cdc.debezium.table.DebeziumChangelogMode;
import org.apache.flink.cdc.debezium.table.DebeziumOptions;
import org.apache.flink.cdc.debezium.utils.ResolvedSchemaUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class PostgreSQLTableFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "postgres-cdc";
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_SNAPSHOT = "snapshot";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String hostname = (String)config.get(JdbcSourceOptions.HOSTNAME);
        String username = (String)config.get(JdbcSourceOptions.USERNAME);
        String password = (String)config.get(JdbcSourceOptions.PASSWORD);
        String databaseName = (String)config.get(JdbcSourceOptions.DATABASE_NAME);
        String schemaName = (String)config.get(JdbcSourceOptions.SCHEMA_NAME);
        String tableName = (String)config.get(JdbcSourceOptions.TABLE_NAME);
        int port = (Integer)config.get(PostgresSourceOptions.PG_PORT);
        String pluginName = (String)config.get(PostgresSourceOptions.DECODING_PLUGIN_NAME);
        String slotName = (String)config.get(PostgresSourceOptions.SLOT_NAME);
        DebeziumChangelogMode changelogMode = (DebeziumChangelogMode)config.get(PostgresSourceOptions.CHANGELOG_MODE);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema((ResolvedSchema)context.getCatalogTable().getResolvedSchema());
        if (changelogMode == DebeziumChangelogMode.UPSERT) {
            Preconditions.checkArgument((boolean)physicalSchema.getPrimaryKey().isPresent(), (Object)"Primary key must be present when upsert mode is selected.");
        }
        boolean enableParallelRead = (Boolean)config.get(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        StartupOptions startupOptions = PostgreSQLTableFactory.getStartupOptions(config);
        int splitSize = (Integer)config.get(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        int splitMetaGroupSize = (Integer)config.get(PostgresSourceOptions.CHUNK_META_GROUP_SIZE);
        int fetchSize = (Integer)config.get(PostgresSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        Duration connectTimeout = (Duration)config.get(PostgresSourceOptions.CONNECT_TIMEOUT);
        int connectMaxRetries = (Integer)config.get(PostgresSourceOptions.CONNECT_MAX_RETRIES);
        int connectionPoolSize = (Integer)config.get(PostgresSourceOptions.CONNECTION_POOL_SIZE);
        double distributionFactorUpper = (Double)config.get(PostgresSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        double distributionFactorLower = (Double)config.get(PostgresSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        Duration heartbeatInterval = (Duration)config.get(PostgresSourceOptions.HEARTBEAT_INTERVAL);
        String chunkKeyColumn = config.getOptional(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN).orElse(null);
        boolean closeIdlerReaders = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED);
        boolean skipSnapshotBackfill = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP);
        boolean isScanNewlyAddedTableEnabled = (Boolean)config.get(SourceOptions.SCAN_NEWLY_ADDED_TABLE_ENABLED);
        int lsnCommitCheckpointsDelay = (Integer)config.get(PostgresSourceOptions.SCAN_LSN_COMMIT_CHECKPOINTS_DELAY);
        if (enableParallelRead) {
            this.validateIntegerOption((ConfigOption<Integer>)PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE, splitSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)PostgresSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE, fetchSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)PostgresSourceOptions.CHUNK_META_GROUP_SIZE, splitMetaGroupSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)JdbcSourceOptions.CONNECTION_POOL_SIZE, connectionPoolSize, 1);
            this.validateIntegerOption((ConfigOption<Integer>)JdbcSourceOptions.CONNECT_MAX_RETRIES, connectMaxRetries, 0);
            this.validateDistributionFactorUpper(distributionFactorUpper);
            this.validateDistributionFactorLower(distributionFactorLower);
        } else {
            Preconditions.checkState((!StartupMode.LATEST_OFFSET.equals((Object)startupOptions.startupMode) ? 1 : 0) != 0, (Object)"The Postgres CDC connector does not support 'latest-offset' startup mode when 'scan.incremental.snapshot.enabled' is disabled, you can enable 'scan.incremental.snapshot.enabled' to use this startup mode.");
        }
        OptionUtils.printOptions(IDENTIFIER, ((Configuration)config).toMap());
        return new PostgreSQLTableSource(physicalSchema, port, hostname, databaseName, schemaName, tableName, username, password, pluginName, slotName, changelogMode, DebeziumOptions.getDebeziumProperties((Map)context.getCatalogTable().getOptions()), enableParallelRead, splitSize, splitMetaGroupSize, fetchSize, connectTimeout, connectMaxRetries, connectionPoolSize, distributionFactorUpper, distributionFactorLower, heartbeatInterval, startupOptions, chunkKeyColumn, closeIdlerReaders, skipSnapshotBackfill, isScanNewlyAddedTableEnabled, lsnCommitCheckpointsDelay);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(JdbcSourceOptions.HOSTNAME);
        options.add(JdbcSourceOptions.USERNAME);
        options.add(JdbcSourceOptions.PASSWORD);
        options.add(JdbcSourceOptions.DATABASE_NAME);
        options.add(JdbcSourceOptions.SCHEMA_NAME);
        options.add(JdbcSourceOptions.TABLE_NAME);
        options.add(PostgresSourceOptions.SLOT_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PostgresSourceOptions.PG_PORT);
        options.add(PostgresSourceOptions.DECODING_PLUGIN_NAME);
        options.add(PostgresSourceOptions.CHANGELOG_MODE);
        options.add(PostgresSourceOptions.SCAN_STARTUP_MODE);
        options.add(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        options.add(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        options.add(PostgresSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN);
        options.add(PostgresSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        options.add(PostgresSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        options.add(PostgresSourceOptions.CHUNK_META_GROUP_SIZE);
        options.add(PostgresSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        options.add(PostgresSourceOptions.CONNECT_TIMEOUT);
        options.add(PostgresSourceOptions.CONNECT_MAX_RETRIES);
        options.add(PostgresSourceOptions.CONNECTION_POOL_SIZE);
        options.add(PostgresSourceOptions.HEARTBEAT_INTERVAL);
        options.add(SourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP);
        options.add(SourceOptions.SCAN_NEWLY_ADDED_TABLE_ENABLED);
        options.add(PostgresSourceOptions.SCAN_LSN_COMMIT_CHECKPOINTS_DELAY);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(PostgresSourceOptions.SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "snapshot": {
                return StartupOptions.snapshot();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s, %s], but was: %s", PostgresSourceOptions.SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_SNAPSHOT, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }

    private void validateIntegerOption(ConfigOption<Integer> option, int optionValue, int exclusiveMin) {
        Preconditions.checkState((optionValue > exclusiveMin ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than %d, but is %d", option.key(), exclusiveMin, optionValue));
    }

    private void validateDistributionFactorUpper(double distributionFactorUpper) {
        Preconditions.checkState((ObjectUtils.doubleCompare((double)distributionFactorUpper, (double)1.0) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than or equals %s, but is %s", PostgresSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.key(), 1.0, distributionFactorUpper));
    }

    private void validateDistributionFactorLower(double distributionFactorLower) {
        Preconditions.checkState((ObjectUtils.doubleCompare((double)distributionFactorLower, (double)0.0) >= 0 && ObjectUtils.doubleCompare((double)distributionFactorLower, (double)1.0) <= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must between %s and %s inclusively, but is %s", PostgresSourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.key(), 0.0, 1.0, distributionFactorLower));
    }
}

