/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase;

import com.oceanbase.clogproxy.client.config.ObReaderConfig;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.oceanbase.source.OceanBaseRichSourceFunction;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class OceanBaseSource {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private StartupOptions startupOptions;
        private String username;
        private String password;
        private String tenantName;
        private String databaseName;
        private String tableName;
        private String tableList;
        private String serverTimeZone;
        private Duration connectTimeout;
        private String hostname;
        private Integer port;
        private String compatibleMode;
        private String jdbcDriver;
        private Properties jdbcProperties;
        private String logProxyHost;
        private Integer logProxyPort;
        private String logProxyClientId;
        private Long startupTimestamp;
        private String rsList;
        private String configUrl;
        private String workingMode;
        private Properties obcdcProperties;
        private Properties debeziumProperties;
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> startupOptions(StartupOptions startupOptions) {
            this.startupOptions = startupOptions;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public Builder<T> databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder<T> tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder<T> tableList(String tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Builder<T> connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> compatibleMode(String compatibleMode) {
            this.compatibleMode = compatibleMode;
            return this;
        }

        public Builder<T> jdbcDriver(String jdbcDriver) {
            this.jdbcDriver = jdbcDriver;
            return this;
        }

        public Builder<T> jdbcProperties(Properties jdbcProperties) {
            this.jdbcProperties = jdbcProperties;
            return this;
        }

        public Builder<T> logProxyHost(String logProxyHost) {
            this.logProxyHost = logProxyHost;
            return this;
        }

        public Builder<T> logProxyPort(Integer logProxyPort) {
            this.logProxyPort = logProxyPort;
            return this;
        }

        public Builder<T> logProxyClientId(String logProxyClientId) {
            this.logProxyClientId = logProxyClientId;
            return this;
        }

        public Builder<T> startupTimestamp(Long startupTimestamp) {
            this.startupTimestamp = startupTimestamp;
            return this;
        }

        public Builder<T> rsList(String rsList) {
            this.rsList = rsList;
            return this;
        }

        public Builder<T> configUrl(String configUrl) {
            this.configUrl = configUrl;
            return this;
        }

        public Builder<T> workingMode(String workingMode) {
            this.workingMode = workingMode;
            return this;
        }

        public Builder<T> obcdcProperties(Properties obcdcProperties) {
            this.obcdcProperties = obcdcProperties;
            return this;
        }

        public Builder<T> debeziumProperties(Properties debeziumProperties) {
            this.debeziumProperties = debeziumProperties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public SourceFunction<T> build() {
            Preconditions.checkNotNull((Object)this.username, (String)"username shouldn't be null");
            Preconditions.checkNotNull((Object)this.password, (String)"password shouldn't be null");
            Preconditions.checkNotNull((Object)this.hostname, (String)"hostname shouldn't be null");
            Preconditions.checkNotNull((Object)this.port, (String)"port shouldn't be null");
            if (this.startupOptions == null) {
                this.startupOptions = StartupOptions.initial();
            }
            if (this.compatibleMode == null) {
                this.compatibleMode = "mysql";
            }
            if (this.jdbcDriver == null) {
                this.jdbcDriver = "com.mysql.cj.jdbc.Driver";
            }
            if (this.connectTimeout == null) {
                this.connectTimeout = Duration.ofSeconds(30L);
            }
            if (this.serverTimeZone == null) {
                this.serverTimeZone = ZoneId.systemDefault().getId();
            }
            switch (this.startupOptions.startupMode) {
                case SNAPSHOT: {
                    break;
                }
                case INITIAL: 
                case LATEST_OFFSET: {
                    this.startupTimestamp = 0L;
                    break;
                }
                case TIMESTAMP: {
                    Preconditions.checkNotNull((Object)this.startupTimestamp, (String)"startupTimestamp shouldn't be null on startup mode 'timestamp'");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.startupOptions.startupMode + " mode is not supported.");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)this.databaseName) || StringUtils.isNotEmpty((CharSequence)this.tableName)) {
                if (StringUtils.isEmpty((CharSequence)this.databaseName) || StringUtils.isEmpty((CharSequence)this.tableName)) {
                    throw new IllegalArgumentException("'database-name' and 'table-name' should be configured at the same time");
                }
            } else {
                Preconditions.checkNotNull((Object)this.tableList, (String)"'database-name', 'table-name' or 'table-list' should be configured");
            }
            Object clientConf = null;
            ObReaderConfig obReaderConfig = null;
            if (!this.startupOptions.isSnapshotOnly()) {
                Preconditions.checkNotNull((Object)this.logProxyHost);
                Preconditions.checkNotNull((Object)this.logProxyPort);
                Preconditions.checkNotNull((Object)this.tenantName);
                obReaderConfig = new ObReaderConfig();
                if (StringUtils.isNotEmpty((CharSequence)this.rsList)) {
                    obReaderConfig.setRsList(this.rsList);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.configUrl)) {
                    obReaderConfig.setClusterUrl(this.configUrl);
                }
                if (StringUtils.isNotEmpty((CharSequence)this.workingMode)) {
                    obReaderConfig.setWorkingMode(this.workingMode);
                }
                obReaderConfig.setUsername(this.username);
                obReaderConfig.setPassword(this.password);
                obReaderConfig.setStartTimestamp(this.startupTimestamp);
                obReaderConfig.setTimezone(DateTimeFormatter.ofPattern("xxx").format(ZoneId.of(this.serverTimeZone).getRules().getOffset(Instant.now())));
                if (this.obcdcProperties != null && !this.obcdcProperties.isEmpty()) {
                    HashMap extraConfigs = new HashMap();
                    this.obcdcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> extraConfigs.put(k.toString(), v.toString())));
                    obReaderConfig.setExtraConfigs(extraConfigs);
                }
            }
            return new OceanBaseRichSourceFunction<T>(this.startupOptions, this.username, this.password, this.tenantName, this.databaseName, this.tableName, this.tableList, this.serverTimeZone, this.connectTimeout, this.hostname, this.port, this.compatibleMode, this.jdbcDriver, this.jdbcProperties, this.logProxyHost, this.logProxyPort, this.logProxyClientId, obReaderConfig, this.debeziumProperties, this.deserializer);
        }
    }
}

