/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.source.config;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.flink.cdc.connectors.oceanbase.source.offset.OceanBaseSourceInfoStructMaker;

public class OceanBaseConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final String LOGICAL_NAME = "oceanbase_cdc_connector";
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = Integer.MIN_VALUE;
    protected static final List<String> BUILT_IN_DB_NAMES = Collections.unmodifiableList(Arrays.asList("information_schema", "mysql", "oceanbase", "LBACSYS", "ORAAUDITOR"));
    private final String compatibleMode;
    private final String serverTimeZone;

    public OceanBaseConnectorConfig(String compatibleMode, String serverTimeZone, Properties properties) {
        super(Configuration.from((Properties)properties), LOGICAL_NAME, Tables.TableFilter.fromPredicate(tableId -> "mysql".equalsIgnoreCase(compatibleMode) ? !BUILT_IN_DB_NAMES.contains(tableId.catalog()) : !BUILT_IN_DB_NAMES.contains(tableId.schema())), TableId::identifier, Integer.MIN_VALUE, "mysql".equalsIgnoreCase(compatibleMode) ? ColumnFilterMode.CATALOG : ColumnFilterMode.SCHEMA);
        this.compatibleMode = compatibleMode;
        this.serverTimeZone = serverTimeZone;
    }

    public String getCompatibleMode() {
        return this.compatibleMode;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getConnectorName() {
        return "oceanbase";
    }

    public String getContextName() {
        return "OceanBase";
    }

    protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new OceanBaseSourceInfoStructMaker();
    }
}

