/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source;

import java.util.Properties;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaMetadataService;
import org.apache.flink.connector.kafka.dynamic.source.DynamicKafkaSourceBuilder;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.DynamicKafkaSourceEnumState;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.DynamicKafkaSourceEnumStateSerializer;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.DynamicKafkaSourceEnumerator;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.subscriber.KafkaStreamSubscriber;
import org.apache.flink.connector.kafka.dynamic.source.reader.DynamicKafkaSourceReader;
import org.apache.flink.connector.kafka.dynamic.source.split.DynamicKafkaSourceSplit;
import org.apache.flink.connector.kafka.dynamic.source.split.DynamicKafkaSourceSplitSerializer;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.core.io.SimpleVersionedSerializer;

@Experimental
public class DynamicKafkaSource<T>
implements Source<T, DynamicKafkaSourceSplit, DynamicKafkaSourceEnumState>,
ResultTypeQueryable<T> {
    private final KafkaStreamSubscriber kafkaStreamSubscriber;
    private final KafkaMetadataService kafkaMetadataService;
    private final KafkaRecordDeserializationSchema<T> deserializationSchema;
    private final OffsetsInitializer startingOffsetsInitializer;
    private final OffsetsInitializer stoppingOffsetsInitializer;
    private final Properties properties;
    private final Boundedness boundedness;

    DynamicKafkaSource(KafkaStreamSubscriber kafkaStreamSubscriber, KafkaMetadataService kafkaMetadataService, KafkaRecordDeserializationSchema<T> deserializationSchema, OffsetsInitializer startingOffsetsInitializer, OffsetsInitializer stoppingOffsetsInitializer, Properties properties, Boundedness boundedness) {
        this.kafkaStreamSubscriber = kafkaStreamSubscriber;
        this.deserializationSchema = deserializationSchema;
        this.properties = properties;
        this.kafkaMetadataService = kafkaMetadataService;
        this.startingOffsetsInitializer = startingOffsetsInitializer;
        this.stoppingOffsetsInitializer = stoppingOffsetsInitializer;
        this.boundedness = boundedness;
    }

    public static <T> DynamicKafkaSourceBuilder<T> builder() {
        return new DynamicKafkaSourceBuilder();
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    @Internal
    public SourceReader<T, DynamicKafkaSourceSplit> createReader(SourceReaderContext readerContext) {
        return new DynamicKafkaSourceReader<T>(readerContext, this.deserializationSchema, this.properties);
    }

    @Internal
    public SplitEnumerator<DynamicKafkaSourceSplit, DynamicKafkaSourceEnumState> createEnumerator(SplitEnumeratorContext<DynamicKafkaSourceSplit> enumContext) {
        return new DynamicKafkaSourceEnumerator(this.kafkaStreamSubscriber, this.kafkaMetadataService, enumContext, this.startingOffsetsInitializer, this.stoppingOffsetsInitializer, this.properties, this.boundedness, new DynamicKafkaSourceEnumState());
    }

    @Internal
    public SplitEnumerator<DynamicKafkaSourceSplit, DynamicKafkaSourceEnumState> restoreEnumerator(SplitEnumeratorContext<DynamicKafkaSourceSplit> enumContext, DynamicKafkaSourceEnumState checkpoint) {
        return new DynamicKafkaSourceEnumerator(this.kafkaStreamSubscriber, this.kafkaMetadataService, enumContext, this.startingOffsetsInitializer, this.stoppingOffsetsInitializer, this.properties, this.boundedness, checkpoint);
    }

    @Internal
    public SimpleVersionedSerializer<DynamicKafkaSourceSplit> getSplitSerializer() {
        return new DynamicKafkaSourceSplitSerializer();
    }

    @Internal
    public SimpleVersionedSerializer<DynamicKafkaSourceEnumState> getEnumeratorCheckpointSerializer() {
        return new DynamicKafkaSourceEnumStateSerializer();
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }

    @VisibleForTesting
    public KafkaStreamSubscriber getKafkaStreamSubscriber() {
        return this.kafkaStreamSubscriber;
    }
}

