/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.Closeable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.connector.kafka.sink.FlinkKafkaInternalProducer;
import org.apache.flink.connector.kafka.sink.TransactionalIdFactory;
import org.apache.flink.util.Preconditions;

class TransactionAborter
implements Closeable {
    private final int subtaskId;
    private final int parallelism;
    private final Function<String, FlinkKafkaInternalProducer<byte[], byte[]>> producerFactory;
    private final Consumer<FlinkKafkaInternalProducer<byte[], byte[]>> closeAction;
    @Nullable
    FlinkKafkaInternalProducer<byte[], byte[]> producer = null;

    public TransactionAborter(int subtaskId, int parallelism, Function<String, FlinkKafkaInternalProducer<byte[], byte[]>> producerFactory, Consumer<FlinkKafkaInternalProducer<byte[], byte[]>> closeAction) {
        this.subtaskId = subtaskId;
        this.parallelism = parallelism;
        this.producerFactory = (Function)Preconditions.checkNotNull(producerFactory);
        this.closeAction = closeAction;
    }

    void abortLingeringTransactions(List<String> prefixesToAbort, long startCheckpointId) {
        for (String prefix : prefixesToAbort) {
            this.abortTransactionsWithPrefix(prefix, startCheckpointId);
        }
    }

    private void abortTransactionsWithPrefix(String prefix, long startCheckpointId) {
        int subtaskId = this.subtaskId;
        while (this.abortTransactionOfSubtask(prefix, startCheckpointId, subtaskId) != 0) {
            subtaskId += this.parallelism;
        }
    }

    private int abortTransactionOfSubtask(String prefix, long startCheckpointId, int subtaskId) {
        int numTransactionAborted = 0;
        long checkpointId = startCheckpointId;
        while (true) {
            String transactionalId = TransactionalIdFactory.buildTransactionalId(prefix, subtaskId, checkpointId);
            if (this.producer == null) {
                this.producer = this.producerFactory.apply(transactionalId);
            } else {
                this.producer.initTransactionId(transactionalId);
            }
            this.producer.flush();
            if (this.producer.getEpoch() == 0) break;
            ++checkpointId;
            ++numTransactionAborted;
        }
        return numTransactionAborted;
    }

    @Override
    public void close() {
        if (this.producer != null) {
            this.closeAction.accept(this.producer);
        }
    }
}

