/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.elasticsearch.sink.FlushBackoffType;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;
import org.apache.http.HttpHost;

@Internal
public class ElasticsearchConfiguration {
    protected final ReadableConfig config;

    ElasticsearchConfiguration(ReadableConfig config) {
        this.config = (ReadableConfig)Preconditions.checkNotNull((Object)config);
    }

    public int getBulkFlushMaxActions() {
        return (Integer)this.config.get(ElasticsearchConnectorOptions.BULK_FLUSH_MAX_ACTIONS_OPTION);
    }

    public MemorySize getBulkFlushMaxByteSize() {
        return (MemorySize)this.config.get(ElasticsearchConnectorOptions.BULK_FLUSH_MAX_SIZE_OPTION);
    }

    public long getBulkFlushInterval() {
        return ((Duration)this.config.get(ElasticsearchConnectorOptions.BULK_FLUSH_INTERVAL_OPTION)).toMillis();
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return (DeliveryGuarantee)this.config.get(ElasticsearchConnectorOptions.DELIVERY_GUARANTEE_OPTION);
    }

    public Optional<String> getUsername() {
        return this.config.getOptional(ElasticsearchConnectorOptions.USERNAME_OPTION);
    }

    public Optional<String> getPassword() {
        return this.config.getOptional(ElasticsearchConnectorOptions.PASSWORD_OPTION);
    }

    public Optional<FlushBackoffType> getBulkFlushBackoffType() {
        return this.config.getOptional(ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION);
    }

    public Optional<Integer> getBulkFlushBackoffRetries() {
        return this.config.getOptional(ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION);
    }

    public Optional<Long> getBulkFlushBackoffDelay() {
        return this.config.getOptional(ElasticsearchConnectorOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION).map(Duration::toMillis);
    }

    public String getIndex() {
        return (String)this.config.get(ElasticsearchConnectorOptions.INDEX_OPTION);
    }

    public String getKeyDelimiter() {
        return (String)this.config.get(ElasticsearchConnectorOptions.KEY_DELIMITER_OPTION);
    }

    public Optional<String> getPathPrefix() {
        return this.config.getOptional(ElasticsearchConnectorOptions.CONNECTION_PATH_PREFIX_OPTION);
    }

    public Optional<Duration> getConnectionRequestTimeout() {
        return this.config.getOptional(ElasticsearchConnectorOptions.CONNECTION_REQUEST_TIMEOUT);
    }

    public Optional<Duration> getConnectionTimeout() {
        return this.config.getOptional(ElasticsearchConnectorOptions.CONNECTION_TIMEOUT);
    }

    public Optional<Duration> getSocketTimeout() {
        return this.config.getOptional(ElasticsearchConnectorOptions.SOCKET_TIMEOUT);
    }

    public List<HttpHost> getHosts() {
        return ((List)this.config.get(ElasticsearchConnectorOptions.HOSTS_OPTION)).stream().map(ElasticsearchConfiguration::validateAndParseHostsString).collect(Collectors.toList());
    }

    public Optional<Integer> getParallelism() {
        return this.config.getOptional(FactoryUtil.SINK_PARALLELISM);
    }

    public static HttpHost validateAndParseHostsString(String host) {
        try {
            HttpHost httpHost = HttpHost.create((String)host);
            if (httpHost.getPort() < 0) {
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'. Missing port.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()));
            }
            if (httpHost.getSchemeName() == null) {
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'. Missing scheme.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()));
            }
            return httpHost;
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()), (Throwable)e);
        }
    }
}

