/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.utils;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2ConnectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Db2ConnectionUtils.class);

    public static Db2Connection createDb2Connection(RelationalDatabaseConnectorConfig connectorConfig) {
        JdbcConfiguration dbzConnectorConfig = connectorConfig.getJdbcConfig();
        return new Db2Connection(JdbcConfiguration.adapt((Configuration)dbzConnectorConfig));
    }

    public static List<TableId> listTables(JdbcConnection jdbc, RelationalTableFilters tableFilters) throws SQLException {
        ArrayList<TableId> capturedTableIds = new ArrayList<TableId>();
        HashSet tableIdSet = new HashSet();
        String queryTablesSql = "SELECT TABSCHEMA, TABNAME FROM SYSCAT.TABLES WHERE TYPE = 'T'";
        Db2Connection db2Connection = (Db2Connection)jdbc;
        try {
            jdbc.query(queryTablesSql, rs -> {
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    TableId tableId = new TableId(db2Connection.getRealDatabaseName(), schemaName, tableName);
                    tableIdSet.add(tableId);
                }
            });
        }
        catch (SQLException e) {
            LOG.warn(" SQL execute error, sql:{}", (Object)queryTablesSql, (Object)e);
        }
        for (TableId tableId : tableIdSet) {
            if (tableFilters.dataCollectionFilter().isIncluded(tableId)) {
                capturedTableIds.add(tableId);
                LOG.info("\t including '{}' for further processing", (Object)tableId);
                continue;
            }
            LOG.debug("\t '{}' is filtered out of capturing", (Object)tableId);
        }
        return capturedTableIds;
    }
}

