/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.offset;

import io.debezium.connector.db2.Lsn;
import java.util.HashMap;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;

public class LsnOffset
extends Offset {
    public static final LsnOffset INITIAL_OFFSET = new LsnOffset(Lsn.valueOf((byte[])new byte[]{-128}));
    public static final LsnOffset NO_STOPPING_OFFSET = new LsnOffset(Lsn.valueOf((byte[])new byte[]{127}));
    private static final String EVENT_SERIAL_NO_KEY = "event_serial_no";

    public LsnOffset(Lsn changeLsn, Lsn commitLsn, Long eventSerialNo) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        if (changeLsn != null && changeLsn.isAvailable()) {
            offsetMap.put("change_lsn", changeLsn.toString());
        }
        if (commitLsn != null && commitLsn.isAvailable()) {
            offsetMap.put("commit_lsn", commitLsn.toString());
        }
        if (eventSerialNo != null) {
            offsetMap.put(EVENT_SERIAL_NO_KEY, String.valueOf(eventSerialNo));
        }
        this.offset = offsetMap;
    }

    public LsnOffset(Lsn changeLsn) {
        this(changeLsn, null, null);
    }

    public int compareTo(Offset offset) {
        LsnOffset that = (LsnOffset)offset;
        if (NO_STOPPING_OFFSET.equals((Object)that) && NO_STOPPING_OFFSET.equals((Object)this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals((Object)this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals((Object)that)) {
            return -1;
        }
        Lsn lsn = Lsn.valueOf((String)((String)this.offset.get("commit_lsn")));
        Lsn targetLsn = Lsn.valueOf((String)((String)that.offset.get("commit_lsn")));
        if (targetLsn.isAvailable()) {
            if (lsn.isAvailable()) {
                return lsn.compareTo(targetLsn);
            }
            return -1;
        }
        if (lsn.isAvailable()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LsnOffset)) {
            return false;
        }
        LsnOffset that = (LsnOffset)((Object)o);
        return this.offset.equals(that.offset);
    }
}

