/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.fetch;

import io.debezium.DebeziumException;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.Db2StreamingChangeEventSource;
import io.debezium.connector.db2.Lsn;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import org.apache.flink.cdc.connectors.base.WatermarkDispatcher;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.apache.flink.cdc.connectors.base.source.meta.wartermark.WatermarkKind;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.db2.source.fetch.Db2ScanFetchTask;
import org.apache.flink.cdc.connectors.db2.source.fetch.Db2SourceFetchTaskContext;
import org.apache.flink.cdc.connectors.db2.source.offset.LsnOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2StreamFetchTask
implements FetchTask<SourceSplitBase> {
    private final StreamSplit split;
    private volatile boolean taskRunning = false;

    public Db2StreamFetchTask(StreamSplit split) {
        this.split = split;
    }

    public void execute(FetchTask.Context context) throws Exception {
        Db2SourceFetchTaskContext sourceFetchContext = (Db2SourceFetchTaskContext)context;
        sourceFetchContext.getOffsetContext().preSnapshotCompletion();
        this.taskRunning = true;
        StreamSplitReadTask streamSplitReadTask = new StreamSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getConnection(), sourceFetchContext.getMetaDataConnection(), (EventDispatcher<Db2Partition, TableId>)sourceFetchContext.getEventDispatcher(), sourceFetchContext.getWaterMarkDispatcher(), sourceFetchContext.getErrorHandler(), sourceFetchContext.getDatabaseSchema(), this.split);
        RedoLogSplitChangeEventSourceContext changeEventSourceContext = new RedoLogSplitChangeEventSourceContext();
        streamSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
    }

    public boolean isRunning() {
        return this.taskRunning;
    }

    public StreamSplit getSplit() {
        return this.split;
    }

    public void close() {
        this.taskRunning = false;
    }

    private class RedoLogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private RedoLogSplitChangeEventSourceContext() {
        }

        public boolean isRunning() {
            return Db2StreamFetchTask.this.taskRunning;
        }
    }

    public static class StreamSplitReadTask
    extends Db2StreamingChangeEventSource {
        private static final Logger LOG = LoggerFactory.getLogger(StreamSplitReadTask.class);
        private final StreamSplit lsnSplit;
        private final WatermarkDispatcher watermarkDispatcher;
        private final ErrorHandler errorHandler;
        private ChangeEventSource.ChangeEventSourceContext context;

        public StreamSplitReadTask(Db2ConnectorConfig connectorConfig, Db2Connection connection, Db2Connection metadataConnection, EventDispatcher<Db2Partition, TableId> eventDispatcher, WatermarkDispatcher watermarkDispatcher, ErrorHandler errorHandler, Db2DatabaseSchema schema, StreamSplit lsnSplit) {
            super(connectorConfig, connection, metadataConnection, eventDispatcher, errorHandler, Clock.system(), schema);
            this.lsnSplit = lsnSplit;
            this.watermarkDispatcher = watermarkDispatcher;
            this.errorHandler = errorHandler;
        }

        @Override
        public void afterHandleLsn(Db2Partition partition, Lsn toLsn) {
            Offset endingOffset;
            LsnOffset currentLsnOffset;
            if (this.isBoundedRead() && (currentLsnOffset = new LsnOffset(null, toLsn, null)).isAtOrAfter(endingOffset = this.lsnSplit.getEndingOffset())) {
                try {
                    this.watermarkDispatcher.dispatchWatermarkEvent(partition.getSourcePartition(), (SourceSplitBase)this.lsnSplit, (Offset)currentLsnOffset, WatermarkKind.END);
                }
                catch (InterruptedException e) {
                    LOG.error("Send signal event error.", (Throwable)e);
                    this.errorHandler.setProducerThrowable((Throwable)new DebeziumException("Error processing redo logs signal event", (Throwable)e));
                }
                ((Db2ScanFetchTask.Db2SnapshotSplitChangeEventSourceContext)this.context).finished();
            }
        }

        private boolean isBoundedRead() {
            return !LsnOffset.NO_STOPPING_OFFSET.equals(this.lsnSplit.getEndingOffset());
        }

        @Override
        public void execute(ChangeEventSource.ChangeEventSourceContext context, Db2Partition partition, Db2OffsetContext offsetContext) throws InterruptedException {
            this.context = context;
            super.execute(context, partition, offsetContext);
        }
    }
}

