/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.utils;

import io.debezium.relational.Column;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public class Db2TypeUtils {
    public static DataType fromDbzColumn(Column column) {
        DataType dataType = Db2TypeUtils.convertFromColumn(column);
        if (column.isOptional()) {
            return dataType;
        }
        return (DataType)dataType.notNull();
    }

    private static DataType convertFromColumn(Column column) {
        switch (column.jdbcType()) {
            case 1: 
            case 12: 
            case 2005: 
            case 2009: {
                return DataTypes.STRING();
            }
            case -3: 
            case -2: 
            case 2004: {
                return DataTypes.BYTES();
            }
            case -6: 
            case 5: {
                return DataTypes.SMALLINT();
            }
            case 4: {
                return DataTypes.INT();
            }
            case -5: {
                return DataTypes.BIGINT();
            }
            case 6: 
            case 7: {
                return DataTypes.FLOAT();
            }
            case 8: {
                return DataTypes.DOUBLE();
            }
            case 2: 
            case 3: {
                return DataTypes.DECIMAL((int)column.length(), (int)column.scale().orElse(0));
            }
            case 91: {
                return DataTypes.DATE();
            }
            case 93: {
                return column.length() >= 0 ? DataTypes.TIMESTAMP((int)column.length()) : DataTypes.TIMESTAMP();
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support DB2 type '%s' yet, jdbcType:'%s'.", column.typeName(), column.jdbcType()));
    }
}

