/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.table;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.db2.Db2Source;
import org.apache.flink.cdc.connectors.db2.source.Db2SourceBuilder;
import org.apache.flink.cdc.connectors.db2.table.Db2ReadableMetaData;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.cdc.debezium.table.MetadataConverter;
import org.apache.flink.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class Db2TableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    protected DataType producedDataType;
    private final int port;
    private final String hostname;
    private final String database;
    private final String tableName;
    private final String username;
    private final String password;
    private final ZoneId serverTimeZone;
    private final StartupOptions startupOptions;
    private final Properties dbzProperties;
    private final boolean enableParallelRead;
    private final int splitSize;
    private final int splitMetaGroupSize;
    private final int fetchSize;
    private final Duration connectTimeout;
    private final int connectionPoolSize;
    private final int connectMaxRetries;
    private final double distributionFactorUpper;
    private final double distributionFactorLower;
    private final String chunkKeyColumn;
    private final boolean closeIdleReaders;
    private final boolean skipSnapshotBackfill;
    protected List<String> metadataKeys;

    public Db2TableSource(ResolvedSchema physicalSchema, int port, String hostname, String database, String tableName, String username, String password, ZoneId serverTimeZone, Properties dbzProperties, StartupOptions startupOptions, boolean enableParallelRead, int splitSize, int splitMetaGroupSize, int fetchSize, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, double distributionFactorUpper, double distributionFactorLower, @Nullable String chunkKeyColumn, boolean closeIdleReaders, boolean skipSnapshotBackfill) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = hostname;
        this.database = database;
        this.tableName = tableName;
        this.username = username;
        this.password = password;
        this.serverTimeZone = serverTimeZone;
        this.dbzProperties = dbzProperties;
        this.startupOptions = startupOptions;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.enableParallelRead = enableParallelRead;
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.fetchSize = fetchSize;
        this.connectTimeout = connectTimeout;
        this.connectionPoolSize = connectionPoolSize;
        this.connectMaxRetries = connectMaxRetries;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.chunkKeyColumn = chunkKeyColumn;
        this.closeIdleReaders = closeIdleReaders;
        this.skipSnapshotBackfill = skipSnapshotBackfill;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.all();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo(typeInfo).setServerTimeZone(this.serverTimeZone).build();
        if (this.enableParallelRead) {
            Db2SourceBuilder.Db2IncrementalSource db2ChangeEventSource = Db2SourceBuilder.Db2IncrementalSource.builder().hostname(this.hostname).port(this.port).databaseList(this.database).tableList(this.tableName).serverTimeZone(this.serverTimeZone.toString()).username(this.username).password(this.password).startupOptions(this.startupOptions).deserializer(deserializer).debeziumProperties(this.dbzProperties).splitSize(this.splitSize).splitMetaGroupSize(this.splitMetaGroupSize).fetchSize(this.fetchSize).connectTimeout(this.connectTimeout).connectionPoolSize(this.connectionPoolSize).connectMaxRetries(this.connectMaxRetries).distributionFactorUpper(this.distributionFactorUpper).distributionFactorLower(this.distributionFactorLower).chunkKeyColumn(this.chunkKeyColumn).closeIdleReaders(this.closeIdleReaders).skipSnapshotBackfill(this.skipSnapshotBackfill).build();
            return SourceProvider.of(db2ChangeEventSource);
        }
        Db2Source.Builder builder = Db2Source.builder().hostname(this.hostname).port(this.port).database(this.database).tableList(this.tableName).username(this.username).password(this.password).debeziumProperties(this.dbzProperties).deserializer(deserializer).startupOptions(this.startupOptions);
        DebeziumSourceFunction sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    private MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(Db2ReadableMetaData.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(Db2ReadableMetaData::getConverter).toArray(MetadataConverter[]::new);
    }

    public DynamicTableSource copy() {
        Db2TableSource source = new Db2TableSource(this.physicalSchema, this.port, this.hostname, this.database, this.tableName, this.username, this.password, this.serverTimeZone, this.dbzProperties, this.startupOptions, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.chunkKeyColumn, this.closeIdleReaders, this.skipSnapshotBackfill);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Db2TableSource)) {
            return false;
        }
        Db2TableSource that = (Db2TableSource)o;
        return this.port == that.port && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.enableParallelRead, that.enableParallelRead) && Objects.equals(this.splitSize, that.splitSize) && Objects.equals(this.splitMetaGroupSize, that.splitMetaGroupSize) && Objects.equals(this.fetchSize, that.fetchSize) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.connectMaxRetries, that.connectMaxRetries) && Objects.equals(this.connectionPoolSize, that.connectionPoolSize) && Objects.equals(this.distributionFactorUpper, that.distributionFactorUpper) && Objects.equals(this.distributionFactorLower, that.distributionFactorLower) && Objects.equals(this.chunkKeyColumn, that.chunkKeyColumn) && Objects.equals(this.closeIdleReaders, that.closeIdleReaders) && Objects.equals(this.skipSnapshotBackfill, that.skipSnapshotBackfill);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.port, this.hostname, this.database, this.tableName, this.username, this.password, this.serverTimeZone, this.dbzProperties, this.metadataKeys, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.chunkKeyColumn, this.closeIdleReaders, this.skipSnapshotBackfill);
    }

    public String asSummaryString() {
        return "DB2-CDC";
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(Db2ReadableMetaData.values()).collect(Collectors.toMap(Db2ReadableMetaData::getKey, Db2ReadableMetaData::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }
}

