/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.compress.writers;

import java.io.IOException;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.formats.compress.extractor.Extractor;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.compress.CompressionOutputStream;

public class HadoopCompressionBulkWriter<T>
implements BulkWriter<T> {
    private final Extractor<T> extractor;
    private final CompressionOutputStream out;

    public HadoopCompressionBulkWriter(CompressionOutputStream out, Extractor<T> extractor) {
        this.out = (CompressionOutputStream)Preconditions.checkNotNull((Object)out);
        this.extractor = (Extractor)Preconditions.checkNotNull(extractor);
    }

    public void addElement(T element) throws IOException {
        this.out.write(this.extractor.extract(element));
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void finish() throws IOException {
        this.out.finish();
    }
}

