/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.client.deployment.application.EntryClassInformationProvider;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.util.Preconditions;

public class FromJarEntryClassInformationProvider
implements EntryClassInformationProvider {
    private final File jarFile;
    private final String jobClassName;

    public static FromJarEntryClassInformationProvider createFromCustomJar(File jarFile, @Nullable String jobClassName) {
        return new FromJarEntryClassInformationProvider(jarFile, jobClassName);
    }

    public static FromJarEntryClassInformationProvider createFromPythonJar() {
        return new FromJarEntryClassInformationProvider(new File(PackagedProgramUtils.getPythonJar().getPath()), PackagedProgramUtils.getPythonDriverClassName());
    }

    private FromJarEntryClassInformationProvider(File jarFile, @Nullable String jobClassName) {
        this.jarFile = (File)Preconditions.checkNotNull((Object)jarFile, (String)"No jar archive is specified.");
        this.jobClassName = jobClassName;
    }

    @Override
    public Optional<File> getJarFile() {
        return Optional.of(this.jarFile);
    }

    @Override
    public Optional<String> getJobClassName() {
        return Optional.ofNullable(this.jobClassName);
    }
}

