/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.tools.ci.utils.shared;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String scope;
    @Nullable
    private final Boolean isOptional;

    private Dependency(String groupId, String artifactId, String version, @Nullable String classifier, @Nullable String scope, @Nullable Boolean isOptional) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
        this.version = Objects.requireNonNull(version);
        this.classifier = classifier;
        this.scope = scope;
        this.isOptional = isOptional;
    }

    public static Dependency create(String groupId, String artifactId, String version, String classifier, String scope, boolean isOptional) {
        return new Dependency(groupId, artifactId, version, classifier, Objects.requireNonNull(scope), isOptional);
    }

    public static Dependency create(String groupId, String artifactId, String version, String classifier) {
        return new Dependency(groupId, artifactId, version, classifier, null, null);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifier);
    }

    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.isOptional);
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + (String)(this.classifier != null ? ":" + this.classifier : "") + (String)(this.scope != null ? ":" + this.scope : "") + (this.isOptional != null && this.isOptional != false ? " (optional)" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.scope, that.scope) && Objects.equals(this.isOptional, that.isOptional);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.scope, this.isOptional);
    }
}

