/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.tools.ci.utils.shared;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ParserUtils {
    public static <D> Map<String, D> parsePluginOutput(Stream<String> lines, Pattern executionLinePattern, Function<Iterator<String>, D> blockParser) {
        LinkedHashMap<String, D> result = new LinkedHashMap<String, D>();
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            Matcher moduleMatcher = executionLinePattern.matcher((CharSequence)iterator.next());
            while (!moduleMatcher.find()) {
                if (iterator.hasNext()) {
                    moduleMatcher = executionLinePattern.matcher((CharSequence)iterator.next());
                    continue;
                }
                return result;
            }
            String currentModule = moduleMatcher.group("module");
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Expected more output from the plugin.");
            }
            result.put(currentModule, blockParser.apply(iterator));
        }
        return result;
    }
}

