/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.tools.ci.utils.dependency;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.tools.ci.utils.shared.Dependency;
import org.apache.flink.tools.ci.utils.shared.DependencyTree;
import org.apache.flink.tools.ci.utils.shared.ParserUtils;

public class DependencyParser {
    private static final Pattern DEPENDENCY_COPY_NEXT_MODULE_PATTERN = Pattern.compile(".*maven-dependency-plugin:[^:]+:copy .* @ (?<module>[^ _]+)(?:_[0-9.]+)? --.*");
    private static final Pattern DEPENDENCY_TREE_NEXT_MODULE_PATTERN = Pattern.compile(".*maven-dependency-plugin:[^:]+:tree .* @ (?<module>[^ _]+)(?:_[0-9.]+)? --.*");
    private static final Pattern DEPENDENCY_TREE_ITEM_PATTERN = Pattern.compile(".* +(?<groupId>.*?):(?<artifactId>.*?):(?<type>.*?):(?:(?<classifier>.*?):)?(?<version>.*?):(?<scope>[^ ]*)(?<optional> \\(optional\\))?");
    private static final Pattern DEPENDENCY_COPY_ITEM_PATTERN = Pattern.compile(".* Configured Artifact: +(?<groupId>.*?):(?<artifactId>.*?):(?:(?<classifier>.*?):)?(?<version>.*?):(?:\\?:)?(?<type>.*)");

    public static Map<String, Set<Dependency>> parseDependencyCopyOutput(Path buildOutput) throws IOException {
        return DependencyParser.processLines(buildOutput, DependencyParser::parseDependencyCopyOutput);
    }

    public static Map<String, DependencyTree> parseDependencyTreeOutput(Path buildOutput) throws IOException {
        return DependencyParser.processLines(buildOutput, DependencyParser::parseDependencyTreeOutput);
    }

    private static <X> X processLines(Path buildOutput, Function<Stream<String>, X> processor) throws IOException {
        try (Stream<String> lines = Files.lines(buildOutput);){
            X x = processor.apply(lines.filter(line -> line.contains("[INFO]")));
            return x;
        }
    }

    @VisibleForTesting
    static Map<String, Set<Dependency>> parseDependencyCopyOutput(Stream<String> lines) {
        return ParserUtils.parsePluginOutput(lines, DEPENDENCY_COPY_NEXT_MODULE_PATTERN, DependencyParser::parseCopyDependencyBlock);
    }

    @VisibleForTesting
    static Map<String, DependencyTree> parseDependencyTreeOutput(Stream<String> lines) {
        return ParserUtils.parsePluginOutput(lines, DEPENDENCY_TREE_NEXT_MODULE_PATTERN, DependencyParser::parseTreeDependencyBlock);
    }

    private static Set<Dependency> parseCopyDependencyBlock(Iterator<String> block) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        Optional<Dependency> parsedDependency = DependencyParser.parseCopyDependency(block.next());
        while (parsedDependency.isPresent()) {
            dependencies.add(parsedDependency.get());
            if (block.hasNext()) {
                parsedDependency = DependencyParser.parseCopyDependency(block.next());
                continue;
            }
            parsedDependency = Optional.empty();
        }
        return dependencies;
    }

    private static DependencyTree parseTreeDependencyBlock(Iterator<String> block) {
        block.next();
        if (!block.hasNext()) {
            throw new IllegalStateException("Expected more output from the dependency-plugin.");
        }
        DependencyTree dependencies = new DependencyTree();
        Stack<Dependency> parentStack = new Stack<Dependency>();
        Stack<Integer> treeDepthStack = new Stack<Integer>();
        String line = block.next();
        Optional<Dependency> parsedDependency = DependencyParser.parseTreeDependency(line);
        while (parsedDependency.isPresent()) {
            int treeDepth = DependencyParser.getDepth(line);
            while (!treeDepthStack.isEmpty() && treeDepth <= (Integer)treeDepthStack.peek()) {
                parentStack.pop();
                treeDepthStack.pop();
            }
            Dependency dependency = parsedDependency.get();
            if (parentStack.isEmpty()) {
                dependencies.addDirectDependency(dependency);
            } else {
                dependencies.addTransitiveDependencyTo(dependency, (Dependency)parentStack.peek());
            }
            if (treeDepthStack.isEmpty() || treeDepth > (Integer)treeDepthStack.peek()) {
                treeDepthStack.push(treeDepth);
                parentStack.push(dependency);
            }
            if (block.hasNext()) {
                line = block.next();
                parsedDependency = DependencyParser.parseTreeDependency(line);
                continue;
            }
            parsedDependency = Optional.empty();
        }
        return dependencies;
    }

    @VisibleForTesting
    static Optional<Dependency> parseCopyDependency(String line) {
        Matcher dependencyMatcher = DEPENDENCY_COPY_ITEM_PATTERN.matcher(line);
        if (!dependencyMatcher.find()) {
            return Optional.empty();
        }
        return Optional.of(Dependency.create(dependencyMatcher.group("groupId"), dependencyMatcher.group("artifactId"), dependencyMatcher.group("version"), dependencyMatcher.group("classifier")));
    }

    @VisibleForTesting
    static Optional<Dependency> parseTreeDependency(String line) {
        Matcher dependencyMatcher = DEPENDENCY_TREE_ITEM_PATTERN.matcher(line);
        if (!dependencyMatcher.find()) {
            return Optional.empty();
        }
        return Optional.of(Dependency.create(dependencyMatcher.group("groupId"), dependencyMatcher.group("artifactId"), dependencyMatcher.group("version"), dependencyMatcher.group("classifier"), dependencyMatcher.group("scope"), dependencyMatcher.group("optional") != null));
    }

    private static int getDepth(String line) {
        int level = line.indexOf(43);
        if (level != -1) {
            return level;
        }
        return line.indexOf(92);
    }
}

