/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.data;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.data.DateData;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class DateDataSerializer
extends TypeSerializerSingleton<DateData> {
    private static final long serialVersionUID = 1L;
    public static final DateDataSerializer INSTANCE = new DateDataSerializer();

    private DateDataSerializer() {
    }

    public boolean isImmutableType() {
        return true;
    }

    public DateData createInstance() {
        return DateData.fromEpochDay((int)0);
    }

    public DateData copy(DateData from) {
        return DateData.fromEpochDay((int)from.toEpochDay());
    }

    public DateData copy(DateData from, DateData reuse) {
        return DateData.fromEpochDay((int)from.toEpochDay());
    }

    public int getLength() {
        return 4;
    }

    public void serialize(DateData record, DataOutputView target) throws IOException {
        target.writeInt(record.toEpochDay());
    }

    public DateData deserialize(DataInputView source) throws IOException {
        return DateData.fromEpochDay((int)source.readInt());
    }

    public DateData deserialize(DateData record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeInt(source.readInt());
    }

    public TypeSerializerSnapshot<DateData> snapshotConfiguration() {
        return new DateDataSerializerSnapshot();
    }

    public static final class DateDataSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<DateData> {
        public DateDataSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

