/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.sink;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.FlushEvent;
import org.apache.flink.cdc.runtime.operators.sink.exception.SinkWrapperException;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;

@Internal
public class BatchDataSinkWriterOperator<CommT>
extends AbstractStreamOperator<CommittableMessage<CommT>>
implements OneInputStreamOperator<Event, CommittableMessage<CommT>>,
BoundedOneInput {
    private final Sink<Event> sink;
    private final ProcessingTimeService processingTimeService;
    private final MailboxExecutor mailboxExecutor;
    private Object flinkWriterOperator;
    private SinkWriter<Event> copySinkWriter;

    public BatchDataSinkWriterOperator(Sink<Event> sink, ProcessingTimeService processingTimeService, MailboxExecutor mailboxExecutor) {
        this.sink = sink;
        this.processingTimeService = processingTimeService;
        this.mailboxExecutor = mailboxExecutor;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<CommittableMessage<CommT>>> output) {
        super.setup(containingTask, config, output);
        this.flinkWriterOperator = this.createFlinkWriterOperator();
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).setup(containingTask, config, output);
    }

    public void open() throws Exception {
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).open();
        this.copySinkWriter = (SinkWriter)this.getFieldValue("sinkWriter");
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).initializeState(context);
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).snapshotState(context);
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).processWatermark(mark);
    }

    public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
        super.processWatermarkStatus(watermarkStatus);
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).processWatermarkStatus(watermarkStatus);
    }

    public void processElement(StreamRecord<Event> element) throws Exception {
        Event event = (Event)element.getValue();
        try {
            ((OneInputStreamOperator)this.getFlinkWriterOperator()).processElement(element);
        }
        catch (Exception e) {
            throw new SinkWrapperException(event, (Throwable)e);
        }
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        ((AbstractStreamOperator)this.getFlinkWriterOperator()).prepareSnapshotPreBarrier(checkpointId);
    }

    public void close() throws Exception {
        ((OneInputStreamOperator)this.getFlinkWriterOperator()).close();
    }

    public void endInput() throws Exception {
        ((BoundedOneInput)this.getFlinkWriterOperator()).endInput();
    }

    private void handleFlushEvent(FlushEvent event) throws Exception {
        this.copySinkWriter.flush(false);
    }

    private Object createFlinkWriterOperator() {
        try {
            Class<?> flinkWriterClass = this.getRuntimeContext().getUserCodeClassLoader().loadClass("org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperator");
            Constructor<?> constructor = flinkWriterClass.getDeclaredConstructor(Sink.class, ProcessingTimeService.class, MailboxExecutor.class);
            constructor.setAccessible(true);
            return constructor.newInstance(this.sink, this.processingTimeService, this.mailboxExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create SinkWriterOperator in Flink", e);
        }
    }

    private <T> T getFieldValue(String fieldName) throws IllegalAccessException {
        for (Class<?> clazz = this.flinkWriterOperator.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (T)field.get(this.flinkWriterOperator);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new RuntimeException("failed to get sinkWriter");
    }

    private <T> T getFlinkWriterOperator() {
        return (T)this.flinkWriterOperator;
    }
}

