/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.runtime.serializer.ListSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.DataFieldSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class RowTypeSerializer
extends TypeSerializerSingleton<RowType> {
    private static final long serialVersionUID = 1L;
    public static final RowTypeSerializer INSTANCE = new RowTypeSerializer();
    private final ListSerializer<DataField> fieldsSerializer = new ListSerializer<DataField>(DataFieldSerializer.INSTANCE);

    public boolean isImmutableType() {
        return false;
    }

    public RowType createInstance() {
        return new RowType(Collections.emptyList());
    }

    public RowType copy(RowType from) {
        return new RowType(from.isNullable(), this.fieldsSerializer.copy(from.getFields()));
    }

    public RowType copy(RowType from, RowType reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(RowType record, DataOutputView target) throws IOException {
        target.writeBoolean(record.isNullable());
        this.fieldsSerializer.serialize(record.getFields(), target);
    }

    public RowType deserialize(DataInputView source) throws IOException {
        boolean nullable = source.readBoolean();
        return new RowType(nullable, (List)this.fieldsSerializer.deserialize(source));
    }

    public RowType deserialize(RowType reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<RowType> snapshotConfiguration() {
        return new RowTypeSerializerSnapshot();
    }

    public static final class RowTypeSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<RowType> {
        public RowTypeSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

