/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.schema;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.MetadataColumn;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.runtime.serializer.StringSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.DataTypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class MetadataColumnSerializer
extends TypeSerializerSingleton<MetadataColumn> {
    private static final long serialVersionUID = 1L;
    public static final MetadataColumnSerializer INSTANCE = new MetadataColumnSerializer();
    private final DataTypeSerializer dataTypeSerializer = new DataTypeSerializer();
    private final StringSerializer stringSerializer = StringSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public MetadataColumn createInstance() {
        return Column.metadataColumn((String)"unknow", (DataType)DataTypes.BIGINT());
    }

    public MetadataColumn copy(MetadataColumn from) {
        return Column.metadataColumn((String)this.stringSerializer.copy(from.getName()), (DataType)this.dataTypeSerializer.copy(from.getType()), (String)this.stringSerializer.copy(from.getMetadataKey()), (String)this.stringSerializer.copy(from.getComment()));
    }

    public MetadataColumn copy(MetadataColumn from, MetadataColumn reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(MetadataColumn record, DataOutputView target) throws IOException {
        this.stringSerializer.serialize(record.getName(), target);
        this.dataTypeSerializer.serialize(record.getType(), target);
        this.stringSerializer.serialize(record.getComment(), target);
        this.stringSerializer.serialize(record.getMetadataKey(), target);
    }

    public MetadataColumn deserialize(DataInputView source) throws IOException {
        String name = this.stringSerializer.deserialize(source);
        DataType dataType = this.dataTypeSerializer.deserialize(source);
        String comment = this.stringSerializer.deserialize(source);
        String metadataKey = this.stringSerializer.deserialize(source);
        return Column.metadataColumn((String)name, (DataType)dataType, (String)metadataKey, (String)comment);
    }

    public MetadataColumn deserialize(MetadataColumn reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<MetadataColumn> snapshotConfiguration() {
        return new MetadataColumnSerializerSnapshot();
    }

    public static final class MetadataColumnSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<MetadataColumn> {
        public MetadataColumnSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

