/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.coordinator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.PhysicalColumn;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.schema.Selectors;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeFamily;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.utils.ChangeEventUtils;
import org.apache.flink.cdc.runtime.operators.schema.coordinator.SchemaManager;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

public class SchemaDerivation {
    private final SchemaManager schemaManager;
    private final List<Tuple2<Selectors, TableId>> routes;
    private final Map<TableId, Set<TableId>> derivationMapping;

    public SchemaDerivation(SchemaManager schemaManager, List<Tuple2<Selectors, TableId>> routes, Map<TableId, Set<TableId>> derivationMapping) {
        this.schemaManager = schemaManager;
        this.routes = routes;
        this.derivationMapping = derivationMapping;
    }

    public List<SchemaChangeEvent> applySchemaChange(SchemaChangeEvent schemaChangeEvent) {
        for (Tuple2<Selectors, TableId> route : this.routes) {
            TableId originalTable = schemaChangeEvent.tableId();
            if (!((Selectors)route.f0).isMatch(originalTable)) continue;
            TableId derivedTable = (TableId)route.f1;
            Set originalTables = this.derivationMapping.computeIfAbsent(derivedTable, t -> new HashSet());
            originalTables.add(originalTable);
            if (originalTables.size() == 1) {
                SchemaChangeEvent derivedSchemaChangeEvent = ChangeEventUtils.recreateSchemaChangeEvent((SchemaChangeEvent)schemaChangeEvent, (TableId)derivedTable);
                this.schemaManager.applySchemaChange(derivedSchemaChangeEvent);
                return Collections.singletonList(derivedSchemaChangeEvent);
            }
            Schema derivedTableSchema = this.schemaManager.getLatestSchema(derivedTable).get();
            if (schemaChangeEvent instanceof CreateTableEvent) {
                return this.handleCreateTableEvent((CreateTableEvent)schemaChangeEvent, derivedTableSchema, derivedTable);
            }
            if (schemaChangeEvent instanceof AddColumnEvent) {
                return this.handleAddColumnEvent((AddColumnEvent)schemaChangeEvent, derivedTableSchema, derivedTable);
            }
            if (schemaChangeEvent instanceof AlterColumnTypeEvent) {
                return this.handleAlterColumnTypeEvent((AlterColumnTypeEvent)schemaChangeEvent, derivedTableSchema, derivedTable);
            }
            if (schemaChangeEvent instanceof DropColumnEvent) {
                return Collections.emptyList();
            }
            if (schemaChangeEvent instanceof RenameColumnEvent) {
                return this.handleRenameColumnEvent((RenameColumnEvent)schemaChangeEvent, derivedTableSchema, derivedTable);
            }
            throw new IllegalStateException(String.format("Unrecognized SchemaChangeEvent type: %s", schemaChangeEvent));
        }
        return Collections.singletonList(schemaChangeEvent);
    }

    public Map<TableId, Set<TableId>> getDerivationMapping() {
        return this.derivationMapping;
    }

    public static void serializeDerivationMapping(SchemaDerivation schemaDerivation, DataOutputStream out) throws IOException {
        TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
        Map<TableId, Set<TableId>> derivationMapping = schemaDerivation.getDerivationMapping();
        out.writeInt(derivationMapping.size());
        for (Map.Entry<TableId, Set<TableId>> entry : derivationMapping.entrySet()) {
            TableId routedTableId = entry.getKey();
            tableIdSerializer.serialize(routedTableId, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            Set<TableId> originalTableIds = entry.getValue();
            out.writeInt(originalTableIds.size());
            for (TableId originalTableId : originalTableIds) {
                tableIdSerializer.serialize(originalTableId, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            }
        }
    }

    public static Map<TableId, Set<TableId>> deserializerDerivationMapping(DataInputStream in) throws IOException {
        TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
        int derivationMappingSize = in.readInt();
        HashMap<TableId, Set<TableId>> derivationMapping = new HashMap<TableId, Set<TableId>>(derivationMappingSize);
        for (int i = 0; i < derivationMappingSize; ++i) {
            TableId routedTableId = tableIdSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
            int numOriginalTables = in.readInt();
            HashSet<TableId> originalTableIds = new HashSet<TableId>(numOriginalTables);
            for (int j = 0; j < numOriginalTables; ++j) {
                TableId originalTableId = tableIdSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
                originalTableIds.add(originalTableId);
            }
            derivationMapping.put(routedTableId, originalTableIds);
        }
        return derivationMapping;
    }

    private List<SchemaChangeEvent> handleRenameColumnEvent(RenameColumnEvent renameColumnEvent, Schema derivedTableSchema, TableId derivedTable) {
        ArrayList newColumns = new ArrayList();
        renameColumnEvent.getNameMapping().forEach((before, after) -> {
            if (derivedTableSchema.getColumn(after).isPresent()) {
                return;
            }
            Column existedColumn = (Column)derivedTableSchema.getColumn(before).get();
            newColumns.add(new AddColumnEvent.ColumnWithPosition((Column)new PhysicalColumn(after, existedColumn.getType(), existedColumn.getComment())));
        });
        ArrayList<SchemaChangeEvent> schemaChangeEvents = new ArrayList<SchemaChangeEvent>();
        if (!newColumns.isEmpty()) {
            AddColumnEvent derivedSchemaChangeEvent = new AddColumnEvent(derivedTable, newColumns);
            schemaChangeEvents.add((SchemaChangeEvent)derivedSchemaChangeEvent);
        }
        schemaChangeEvents.forEach(this.schemaManager::applySchemaChange);
        return schemaChangeEvents;
    }

    private List<SchemaChangeEvent> handleAlterColumnTypeEvent(AlterColumnTypeEvent alterColumnTypeEvent, Schema derivedTableSchema, TableId derivedTable) {
        HashMap typeDifference = new HashMap();
        alterColumnTypeEvent.getTypeMapping().forEach((columnName, dataType) -> {
            DataType widerType;
            Column existedColumnInDerivedTable = (Column)derivedTableSchema.getColumn(columnName).get();
            if (!existedColumnInDerivedTable.getType().equals(dataType) && !(widerType = this.getWiderType(existedColumnInDerivedTable.getType(), (DataType)dataType)).equals((Object)existedColumnInDerivedTable.getType())) {
                typeDifference.put(existedColumnInDerivedTable.getName(), widerType);
            }
        });
        ArrayList<SchemaChangeEvent> schemaChangeEvents = new ArrayList<SchemaChangeEvent>();
        if (!typeDifference.isEmpty()) {
            AlterColumnTypeEvent derivedSchemaChangeEvent = new AlterColumnTypeEvent(derivedTable, typeDifference);
            schemaChangeEvents.add((SchemaChangeEvent)derivedSchemaChangeEvent);
        }
        schemaChangeEvents.forEach(this.schemaManager::applySchemaChange);
        return schemaChangeEvents;
    }

    private List<SchemaChangeEvent> handleAddColumnEvent(AddColumnEvent addColumnEvent, Schema derivedTableSchema, TableId derivedTable) {
        ArrayList<AddColumnEvent.ColumnWithPosition> newColumns = new ArrayList<AddColumnEvent.ColumnWithPosition>();
        HashMap<String, DataType> newTypeMapping = new HashMap<String, DataType>();
        for (AddColumnEvent.ColumnWithPosition addedColumn : addColumnEvent.getAddedColumns()) {
            DataType widerType;
            Optional optionalColumnInDerivedTable = derivedTableSchema.getColumn(addedColumn.getAddColumn().getName());
            if (!optionalColumnInDerivedTable.isPresent()) {
                newColumns.add(new AddColumnEvent.ColumnWithPosition(addedColumn.getAddColumn()));
                continue;
            }
            Column existedColumnInDerivedTable = (Column)optionalColumnInDerivedTable.get();
            if (existedColumnInDerivedTable.getType().equals((Object)addedColumn.getAddColumn().getType()) || (widerType = this.getWiderType(existedColumnInDerivedTable.getType(), addedColumn.getAddColumn().getType())).equals((Object)existedColumnInDerivedTable.getType())) continue;
            newTypeMapping.put(existedColumnInDerivedTable.getName(), widerType);
        }
        ArrayList<SchemaChangeEvent> schemaChangeEvents = new ArrayList<SchemaChangeEvent>();
        if (!newColumns.isEmpty()) {
            schemaChangeEvents.add((SchemaChangeEvent)new AddColumnEvent(derivedTable, newColumns));
        }
        if (!newTypeMapping.isEmpty()) {
            schemaChangeEvents.add((SchemaChangeEvent)new AlterColumnTypeEvent(derivedTable, newTypeMapping));
        }
        schemaChangeEvents.forEach(this.schemaManager::applySchemaChange);
        return schemaChangeEvents;
    }

    private List<SchemaChangeEvent> handleCreateTableEvent(CreateTableEvent createTableEvent, Schema derivedTableSchema, TableId derivedTable) {
        ArrayList<AddColumnEvent.ColumnWithPosition> newColumns = new ArrayList<AddColumnEvent.ColumnWithPosition>();
        HashMap<String, DataType> newTypeMapping = new HashMap<String, DataType>();
        for (Column column : createTableEvent.getSchema().getColumns()) {
            DataType widerType;
            Optional optionalColumnInDerivedTable = derivedTableSchema.getColumn(column.getName());
            if (!optionalColumnInDerivedTable.isPresent()) {
                newColumns.add(new AddColumnEvent.ColumnWithPosition(column));
                continue;
            }
            Column existedColumnInDerivedTable = (Column)optionalColumnInDerivedTable.get();
            if (existedColumnInDerivedTable.getType().equals((Object)column.getType()) || (widerType = this.getWiderType(existedColumnInDerivedTable.getType(), column.getType())).equals((Object)existedColumnInDerivedTable.getType())) continue;
            newTypeMapping.put(existedColumnInDerivedTable.getName(), widerType);
        }
        ArrayList<SchemaChangeEvent> schemaChangeEvents = new ArrayList<SchemaChangeEvent>();
        if (!newColumns.isEmpty()) {
            schemaChangeEvents.add((SchemaChangeEvent)new AddColumnEvent(derivedTable, newColumns));
        }
        if (!newTypeMapping.isEmpty()) {
            schemaChangeEvents.add((SchemaChangeEvent)new AlterColumnTypeEvent(derivedTable, newTypeMapping));
        }
        schemaChangeEvents.forEach(this.schemaManager::applySchemaChange);
        return schemaChangeEvents;
    }

    private DataType getWiderType(DataType thisType, DataType thatType) {
        if (thisType.equals((Object)thatType)) {
            return thisType;
        }
        if (thisType.is(DataTypeFamily.INTEGER_NUMERIC) && thatType.is(DataTypeFamily.INTEGER_NUMERIC)) {
            return DataTypes.BIGINT();
        }
        if (thisType.is(DataTypeFamily.CHARACTER_STRING) && thatType.is(DataTypeFamily.CHARACTER_STRING)) {
            return DataTypes.STRING();
        }
        if (thisType.is(DataTypeFamily.APPROXIMATE_NUMERIC) && thatType.is(DataTypeFamily.APPROXIMATE_NUMERIC)) {
            return DataTypes.DOUBLE();
        }
        throw new IllegalStateException(String.format("Incompatible types: \"%s\" and \"%s\"", thisType, thatType));
    }
}

