/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.values.sink;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.ChangeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.cdc.connectors.values.ValuesDatabase;
import org.apache.flink.cdc.connectors.values.sink.ValuesDataSinkHelper;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

public class ValuesDataSinkFunction
implements SinkFunction<Event> {
    private final boolean materializedInMemory;
    private final boolean print;
    private final Map<TableId, Schema> schemaMaps;
    private final Map<TableId, List<RecordData.FieldGetter>> fieldGetterMaps;

    public ValuesDataSinkFunction(boolean materializedInMemory, boolean print) {
        this.materializedInMemory = materializedInMemory;
        this.print = print;
        this.schemaMaps = new HashMap<TableId, Schema>();
        this.fieldGetterMaps = new HashMap<TableId, List<RecordData.FieldGetter>>();
    }

    public void invoke(Event event, SinkFunction.Context context) throws Exception {
        if (event instanceof SchemaChangeEvent) {
            SchemaChangeEvent schemaChangeEvent = (SchemaChangeEvent)event;
            TableId tableId = schemaChangeEvent.tableId();
            if (event instanceof CreateTableEvent) {
                Schema schema = ((CreateTableEvent)event).getSchema();
                this.schemaMaps.put(tableId, schema);
                this.fieldGetterMaps.put(tableId, SchemaUtils.createFieldGetters((Schema)schema));
            } else {
                if (!this.schemaMaps.containsKey(tableId)) {
                    throw new RuntimeException("schema of " + tableId + " is not existed.");
                }
                Schema schema = SchemaUtils.applySchemaChangeEvent((Schema)this.schemaMaps.get(tableId), (SchemaChangeEvent)schemaChangeEvent);
                this.schemaMaps.put(tableId, schema);
                this.fieldGetterMaps.put(tableId, SchemaUtils.createFieldGetters((Schema)schema));
            }
        } else if (this.materializedInMemory && event instanceof DataChangeEvent) {
            ValuesDatabase.applyDataChangeEvent((DataChangeEvent)event);
        }
        if (this.print) {
            System.out.println(ValuesDataSinkHelper.convertEventToStr(event, this.fieldGetterMaps.get(((ChangeEvent)event).tableId())));
        }
    }

    public void writeWatermark(Watermark watermark) throws Exception {
        super.writeWatermark(watermark);
    }

    public void finish() throws Exception {
        super.finish();
    }
}

