/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.utils;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresObjectUtils;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.connectors.postgres.source.PostgresDialect;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfig;
import org.apache.flink.cdc.connectors.postgres.utils.PostgresTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresSchemaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresSchemaUtils.class);
    private static final Map<String, PostgresDialect> dialectCache = new ConcurrentHashMap<String, PostgresDialect>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listSchemas(PostgresSourceConfig sourceConfig, String namespace) {
        try (PostgresConnection jdbc = PostgresSchemaUtils.getPostgresDialect(sourceConfig).openJdbcConnection();){
            List<String> list = PostgresSchemaUtils.listSchemas(jdbc, namespace);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error to list schemas: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listNamespaces(PostgresSourceConfig sourceConfig) {
        try (PostgresConnection jdbc = PostgresSchemaUtils.getPostgresDialect(sourceConfig).openJdbcConnection();){
            List<String> list = PostgresSchemaUtils.listNamespaces(jdbc);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error to list namespaces: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<org.apache.flink.cdc.common.event.TableId> listTables(PostgresSourceConfig sourceConfig, @Nullable String dbName) {
        try (PostgresConnection jdbc = PostgresSchemaUtils.getPostgresDialect(sourceConfig).openJdbcConnection();){
            List<String> databases = dbName != null ? Collections.singletonList(dbName) : Collections.singletonList(sourceConfig.getDatabaseList().get(0));
            ArrayList tableIds = new ArrayList();
            for (String database : databases) {
                List tableIdList = jdbc.getAllTableIds(database).stream().map(PostgresSchemaUtils::toCdcTableId).collect(Collectors.toList());
                tableIds.addAll(tableIdList);
            }
            ArrayList arrayList = tableIds;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error to list databases: " + e.getMessage(), e);
        }
    }

    public static Schema getTableSchema(PostgresSourceConfig sourceConfig, org.apache.flink.cdc.common.event.TableId tableId) {
        try (PostgresConnection jdbc = PostgresSchemaUtils.getPostgresDialect(sourceConfig).openJdbcConnection();){
            Schema schema = PostgresSchemaUtils.getTableSchema(tableId, sourceConfig, jdbc);
            return schema;
        }
    }

    public static PostgresDialect getPostgresDialect(PostgresSourceConfig sourceConfig) {
        String key = sourceConfig.getJdbcUrl();
        return dialectCache.computeIfAbsent(key, k -> new PostgresDialect(sourceConfig));
    }

    public static List<String> listSchemas(JdbcConnection jdbc, String namespace) throws SQLException {
        LOG.info("Read list of available schemas");
        ArrayList<String> schemaNames = new ArrayList<String>();
        String querySql = String.format("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE CATALOG_NAME = %s", PostgresSchemaUtils.quote(namespace));
        jdbc.query(querySql, rs -> {
            while (rs.next()) {
                schemaNames.add(rs.getString(1));
            }
        });
        LOG.info("\t list of available schemas are: {}", schemaNames);
        return schemaNames;
    }

    public static List<String> listNamespaces(JdbcConnection jdbc) throws SQLException {
        LOG.info("Read list of available namespaces");
        ArrayList<String> namespaceNames = new ArrayList<String>();
        jdbc.query("SELECT DATNAME FROM PG_DATABASE", rs -> {
            while (rs.next()) {
                namespaceNames.add(rs.getString(1));
            }
        });
        LOG.info("\t list of available namespaces are: {}", namespaceNames);
        return namespaceNames;
    }

    public static String quote(String dbOrTableName) {
        return "\"" + dbOrTableName + "\"";
    }

    public static Schema getTableSchema(org.apache.flink.cdc.common.event.TableId tableId, PostgresSourceConfig sourceConfig, PostgresConnection jdbc) {
        return PostgresSchemaUtils.getTableSchema(PostgresSchemaUtils.toDbzTableId(tableId), sourceConfig, jdbc);
    }

    public static Schema getTableSchema(TableId tableId, PostgresSourceConfig sourceConfig, PostgresConnection jdbc) {
        try {
            TopicSelector<TableId> topicSelector = PostgresTopicSelector.create(sourceConfig.getDbzConnectorConfig());
            PostgresConnection.PostgresValueConverterBuilder valueConverterBuilder = PostgresObjectUtils.newPostgresValueConverterBuilder(sourceConfig.getDbzConnectorConfig());
            PostgresSchema postgresSchema = PostgresObjectUtils.newSchema(jdbc, sourceConfig.getDbzConnectorConfig(), jdbc.getTypeRegistry(), topicSelector, valueConverterBuilder.build(jdbc.getTypeRegistry()));
            Table tableSchema = postgresSchema.tableFor(tableId);
            return PostgresSchemaUtils.toSchema(tableSchema, sourceConfig.getDbzConnectorConfig(), jdbc.getTypeRegistry());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize PostgresReplicationConnection", e);
        }
    }

    public static Schema toSchema(Table table, PostgresConnectorConfig dbzConfig, TypeRegistry typeRegistry) {
        List columns = table.columns().stream().map(column -> PostgresSchemaUtils.toColumn(column, dbzConfig, typeRegistry)).collect(Collectors.toList());
        return Schema.newBuilder().setColumns(columns).primaryKey(table.primaryKeyColumnNames()).comment(table.comment()).build();
    }

    public static Column toColumn(io.debezium.relational.Column column, PostgresConnectorConfig dbzConfig, TypeRegistry typeRegistry) {
        if (column.defaultValueExpression().isPresent()) {
            return Column.physicalColumn((String)column.name(), (DataType)PostgresTypeUtils.fromDbzColumn(column, dbzConfig, typeRegistry), (String)column.comment(), (String)column.defaultValueExpression().get());
        }
        return Column.physicalColumn((String)column.name(), (DataType)PostgresTypeUtils.fromDbzColumn(column, dbzConfig, typeRegistry), (String)column.comment());
    }

    public static TableId toDbzTableId(org.apache.flink.cdc.common.event.TableId tableId) {
        return new TableId(tableId.getSchemaName(), null, tableId.getTableName());
    }

    public static org.apache.flink.cdc.common.event.TableId toCdcTableId(TableId dbzTableId) {
        return org.apache.flink.cdc.common.event.TableId.tableId((String)dbzTableId.schema(), (String)dbzTableId.table());
    }
}

