/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.binary.BinaryStringData;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.connectors.postgres.source.PostgresSchemaDataTypeInference;
import org.apache.flink.cdc.connectors.postgres.table.PostgreSQLReadableMetadata;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.debezium.event.DebeziumEventDeserializationSchema;
import org.apache.flink.cdc.debezium.table.DebeziumChangelogMode;
import org.apache.flink.table.data.TimestampData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;

@Internal
public class PostgresEventDeserializer
extends DebeziumEventDeserializationSchema {
    private static final long serialVersionUID = 1L;
    private List<PostgreSQLReadableMetadata> readableMetadataList;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public PostgresEventDeserializer(DebeziumChangelogMode changelogMode) {
        super(new PostgresSchemaDataTypeInference(), changelogMode);
    }

    public PostgresEventDeserializer(DebeziumChangelogMode changelogMode, List<PostgreSQLReadableMetadata> readableMetadataList) {
        super(new PostgresSchemaDataTypeInference(), changelogMode);
        this.readableMetadataList = readableMetadataList;
    }

    @Override
    protected List<SchemaChangeEvent> deserializeSchemaChangeRecord(SourceRecord record) {
        return Collections.emptyList();
    }

    @Override
    protected boolean isDataChangeRecord(SourceRecord record) {
        Schema valueSchema = record.valueSchema();
        Struct value = (Struct)record.value();
        return value != null && valueSchema != null && valueSchema.field("op") != null && value.getString("op") != null;
    }

    @Override
    protected boolean isSchemaChangeRecord(SourceRecord record) {
        return false;
    }

    @Override
    protected TableId getTableId(SourceRecord record) {
        String[] parts = record.topic().split("\\.");
        return TableId.tableId((String)parts[1], (String)parts[2]);
    }

    @Override
    protected Map<String, String> getMetadata(SourceRecord record) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        this.readableMetadataList.forEach(postgresReadableMetadata -> {
            Object metadata = postgresReadableMetadata.getConverter().read(record);
            if (postgresReadableMetadata.equals((Object)PostgreSQLReadableMetadata.OP_TS)) {
                metadataMap.put(postgresReadableMetadata.getKey(), String.valueOf(((TimestampData)metadata).getMillisecond()));
            } else {
                metadataMap.put(postgresReadableMetadata.getKey(), String.valueOf(metadata));
            }
        });
        return metadataMap;
    }

    @Override
    protected Object convertToString(Object dbzObj, Schema schema) {
        if ("io.debezium.data.geometry.Point".equals(schema.name()) || "io.debezium.data.geometry.Geometry".equals(schema.name()) || "io.debezium.data.geometry.Geography".equals(schema.name())) {
            try {
                Struct geometryStruct = (Struct)dbzObj;
                byte[] wkb = geometryStruct.getBytes("wkb");
                WKBReader wkbReader = new WKBReader();
                Geometry jtsGeom = wkbReader.read(wkb);
                Optional<Integer> srid = Optional.ofNullable(geometryStruct.getInt32("srid"));
                HashMap<String, Object> geometryInfo = new HashMap<String, Object>();
                String geometryType = jtsGeom.getGeometryType();
                geometryInfo.put("type", geometryType);
                if (geometryType.equals("GeometryCollection")) {
                    geometryInfo.put("geometries", jtsGeom.toText());
                } else {
                    Coordinate[] coordinates = jtsGeom.getCoordinates();
                    ArrayList<double[]> coordinateList = new ArrayList<double[]>();
                    if (coordinates != null) {
                        for (Coordinate coordinate : coordinates) {
                            coordinateList.add(new double[]{coordinate.x, coordinate.y});
                            geometryInfo.put("coordinates", new double[]{coordinate.x, coordinate.y});
                        }
                    }
                    geometryInfo.put("coordinates", OBJECT_MAPPER.writeValueAsString(coordinateList));
                }
                geometryInfo.put("srid", srid.orElse(0));
                return BinaryStringData.fromString((String)OBJECT_MAPPER.writeValueAsString(geometryInfo));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", dbzObj), e);
            }
        }
        return BinaryStringData.fromString((String)dbzObj.toString());
    }
}

