/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.source.DataSource;
import org.apache.flink.cdc.common.source.EventSourceProvider;
import org.apache.flink.cdc.common.source.FlinkSourceProvider;
import org.apache.flink.cdc.common.source.MetadataAccessor;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceRecords;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitState;
import org.apache.flink.cdc.connectors.base.source.metrics.SourceReaderMetrics;
import org.apache.flink.cdc.connectors.postgres.source.PostgresDialect;
import org.apache.flink.cdc.connectors.postgres.source.PostgresEventDeserializer;
import org.apache.flink.cdc.connectors.postgres.source.PostgresMetadataAccessor;
import org.apache.flink.cdc.connectors.postgres.source.PostgresSourceBuilder;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfig;
import org.apache.flink.cdc.connectors.postgres.source.config.PostgresSourceConfigFactory;
import org.apache.flink.cdc.connectors.postgres.source.offset.PostgresOffsetFactory;
import org.apache.flink.cdc.connectors.postgres.source.reader.PostgresPipelineRecordEmitter;
import org.apache.flink.cdc.connectors.postgres.table.PostgreSQLReadableMetadata;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.table.DebeziumChangelogMode;
import org.apache.flink.connector.base.source.reader.RecordEmitter;

@Internal
public class PostgresDataSource
implements DataSource {
    private final PostgresSourceConfigFactory configFactory;
    private final PostgresSourceConfig postgresSourceConfig;
    private final List<PostgreSQLReadableMetadata> readableMetadataList;

    public PostgresDataSource(PostgresSourceConfigFactory configFactory) {
        this(configFactory, new ArrayList<PostgreSQLReadableMetadata>());
    }

    public PostgresDataSource(PostgresSourceConfigFactory configFactory, List<PostgreSQLReadableMetadata> readableMetadataList) {
        this.configFactory = configFactory;
        this.postgresSourceConfig = configFactory.create(0);
        this.readableMetadataList = readableMetadataList;
    }

    public EventSourceProvider getEventSourceProvider() {
        PostgresEventDeserializer deserializer = new PostgresEventDeserializer(DebeziumChangelogMode.ALL, this.readableMetadataList);
        PostgresOffsetFactory postgresOffsetFactory = new PostgresOffsetFactory();
        PostgresDialect postgresDialect = new PostgresDialect(this.postgresSourceConfig);
        PostgresPipelineSource<Event> source = new PostgresPipelineSource<Event>(this.configFactory, deserializer, postgresOffsetFactory, postgresDialect, this.postgresSourceConfig);
        return FlinkSourceProvider.of(source);
    }

    public MetadataAccessor getMetadataAccessor() {
        return new PostgresMetadataAccessor(this.postgresSourceConfig);
    }

    @VisibleForTesting
    public PostgresSourceConfig getPostgresSourceConfig() {
        return this.postgresSourceConfig;
    }

    public static class PostgresPipelineSource<T>
    extends PostgresSourceBuilder.PostgresIncrementalSource<T> {
        private final PostgresSourceConfig sourceConfig;
        private final PostgresDialect dataSourceDialect;

        public PostgresPipelineSource(PostgresSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, PostgresOffsetFactory offsetFactory, PostgresDialect dataSourceDialect, PostgresSourceConfig sourceConfig) {
            super(configFactory, deserializationSchema, offsetFactory, dataSourceDialect);
            this.sourceConfig = sourceConfig;
            this.dataSourceDialect = dataSourceDialect;
        }

        @Override
        protected RecordEmitter<SourceRecords, T, SourceSplitState> createRecordEmitter(SourceConfig sourceConfig, SourceReaderMetrics sourceReaderMetrics) {
            return new PostgresPipelineRecordEmitter(this.deserializationSchema, sourceReaderMetrics, this.sourceConfig, this.offsetFactory, this.dataSourceDialect);
        }
    }
}

