/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.time.Conversions;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import org.apache.flink.cdc.connectors.postgres.source.offset.PostgresOffset;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static Lsn lastKnownLsn(PostgresOffsetContext ctx) {
        return ctx.lsn();
    }

    public static PostgresOffset currentOffset(PostgresConnection jdbcConnection) {
        Long txId;
        Long lsn;
        try {
            lsn = jdbcConnection.currentXLogLocation();
            txId = jdbcConnection.currentTransactionId();
            LOGGER.trace("Read xlogStart at '{}' from transaction '{}'", (Object)Lsn.valueOf(lsn), (Object)txId);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error getting current Lsn/txId " + e.getMessage(), (Throwable)e);
        }
        try {
            jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("JDBC connection fails to commit: " + e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("lsn", lsn.toString());
        if (txId != null) {
            offsetMap.put("txId", txId.toString());
        }
        offsetMap.put("ts_usec", String.valueOf(Conversions.toEpochMicros(Instant.MIN)));
        return PostgresOffset.of(offsetMap);
    }

    public static PostgresSchema refreshSchema(PostgresSchema schema, PostgresConnection pgConnection, boolean printReplicaIdentityInfo) throws SQLException {
        return schema.refresh(pgConnection, printReplicaIdentityInfo);
    }
}

