/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.BigIntType;
import org.apache.flink.cdc.common.types.BinaryType;
import org.apache.flink.cdc.common.types.BooleanType;
import org.apache.flink.cdc.common.types.CharType;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeDefaultVisitor;
import org.apache.flink.cdc.common.types.DataTypeVisitor;
import org.apache.flink.cdc.common.types.DateType;
import org.apache.flink.cdc.common.types.DecimalType;
import org.apache.flink.cdc.common.types.DoubleType;
import org.apache.flink.cdc.common.types.FloatType;
import org.apache.flink.cdc.common.types.IntType;
import org.apache.flink.cdc.common.types.LocalZonedTimestampType;
import org.apache.flink.cdc.common.types.SmallIntType;
import org.apache.flink.cdc.common.types.TimeType;
import org.apache.flink.cdc.common.types.TimestampType;
import org.apache.flink.cdc.common.types.TinyIntType;
import org.apache.flink.cdc.common.types.VarBinaryType;
import org.apache.flink.cdc.common.types.VarCharType;
import org.apache.flink.cdc.common.types.ZonedTimestampType;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalogException;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseColumn;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseTable;
import org.apache.flink.cdc.connectors.oceanbase.utils.ListUtils;

public class OceanBaseUtils {
    public static final String BOOLEAN = "BOOLEAN";
    public static final String TINYINT = "TINYINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String INT = "INT";
    public static final String BIGINT = "BIGINT";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String DECIMAL = "DECIMAL";
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String STRING = "STRING";
    public static final String DATE = "DATE";
    public static final String DATETIME = "DATETIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIME = "TIME";
    public static final String JSON = "JSON";
    public static final String TEXT = "TEXT";
    public static final String LONGBLOB = "LONGBLOB";
    public static final int MAX_CHAR_SIZE = 256;
    public static final int MAX_VARCHAR_SIZE = 262144;
    public static final int MAX_VARBINARY_SIZE = 0x100000;

    public static OceanBaseTable toOceanBaseTable(TableId tableId, Schema schema) {
        List columns = schema.getColumns();
        List primaryKeys = schema.primaryKeys();
        List partitionKeys = schema.partitionKeys();
        ArrayList<OceanBaseColumn> oceanBaseColumns = new ArrayList<OceanBaseColumn>();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            boolean isPrimaryKeys = primaryKeys.contains(column.getName()) || partitionKeys.contains(column.getName());
            OceanBaseUtils.checkPrimaryKeyNotNull(isPrimaryKeys, column.getType().isNullable());
            OceanBaseColumn.Builder builder = new OceanBaseColumn.Builder().setColumnName(column.getName()).setOrdinalPosition(i).setDefaultValue(column.getDefaultValueExpression()).setColumnComment(column.getComment());
            OceanBaseUtils.toOceanBaseDataType(column, isPrimaryKeys, builder);
            oceanBaseColumns.add(builder.build());
        }
        OceanBaseTable.Builder tableBuilder = new OceanBaseTable.Builder().setDatabaseName(tableId.getSchemaName()).setTableName(tableId.getTableName()).setTableType(CollectionUtils.isNotEmpty((Collection)primaryKeys) ? OceanBaseTable.TableType.PRIMARY_KEY : OceanBaseTable.TableType.DUPLICATE_KEY).setColumns(oceanBaseColumns).setTableKeys(ListUtils.union(primaryKeys, partitionKeys)).setPartitionKeys(schema.partitionKeys()).setComment(schema.comment());
        return tableBuilder.build();
    }

    public static void toOceanBaseDataType(Column cdcColumn, boolean isPrimaryKeys, OceanBaseColumn.Builder builder) {
        CdcDataTypeTransformer dataTypeTransformer = new CdcDataTypeTransformer(isPrimaryKeys, builder);
        cdcColumn.getType().accept((DataTypeVisitor)dataTypeTransformer);
    }

    private static void checkPrimaryKeyNotNull(boolean isPrimaryKeys, boolean dataTypeNullable) {
        if (isPrimaryKeys && dataTypeNullable) {
            throw new OceanBaseCatalogException("All parts of a PRIMARY KEY must be NOT NULL in OceanBase. if you need NULL in a key, use UNIQUE instead.");
        }
    }

    public static class CdcDataTypeTransformer
    extends DataTypeDefaultVisitor<OceanBaseColumn.Builder> {
        private final OceanBaseColumn.Builder builder;
        private final boolean isPrimaryKeys;

        public CdcDataTypeTransformer(boolean isPrimaryKeys, OceanBaseColumn.Builder builder) {
            this.isPrimaryKeys = isPrimaryKeys;
            this.builder = builder;
        }

        public OceanBaseColumn.Builder visit(BooleanType booleanType) {
            this.builder.setDataType(OceanBaseUtils.BOOLEAN);
            this.builder.setNullable(booleanType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(TinyIntType tinyIntType) {
            this.builder.setDataType(OceanBaseUtils.TINYINT);
            this.builder.setNullable(tinyIntType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(SmallIntType smallIntType) {
            this.builder.setDataType(OceanBaseUtils.SMALLINT);
            this.builder.setNullable(smallIntType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(IntType intType) {
            this.builder.setDataType(OceanBaseUtils.INT);
            this.builder.setNullable(intType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(BigIntType bigIntType) {
            this.builder.setDataType(OceanBaseUtils.BIGINT);
            this.builder.setNullable(bigIntType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(BinaryType binaryType) {
            this.builder.setDataType(OceanBaseUtils.BINARY);
            this.builder.setNullable(binaryType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(VarBinaryType bytesType) {
            int length = bytesType.getLength();
            if (length <= 0x100000) {
                this.builder.setDataType(OceanBaseUtils.VARBINARY);
                this.builder.setColumnSize(length);
                this.builder.setNullable(bytesType.isNullable());
            } else {
                this.builder.setDataType(OceanBaseUtils.LONGBLOB);
                this.builder.setNullable(bytesType.isNullable());
            }
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(FloatType floatType) {
            this.builder.setDataType(OceanBaseUtils.FLOAT);
            this.builder.setNullable(floatType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(DoubleType doubleType) {
            this.builder.setDataType(OceanBaseUtils.DOUBLE);
            this.builder.setNullable(doubleType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(DecimalType decimalType) {
            this.builder.setDataType(OceanBaseUtils.DECIMAL);
            this.builder.setColumnSize(decimalType.getPrecision());
            this.builder.setNumericScale(decimalType.getScale());
            this.builder.setNullable(decimalType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(CharType charType) {
            int length = charType.getLength();
            if (length <= 256) {
                this.builder.setDataType(OceanBaseUtils.CHAR);
                this.builder.setNullable(charType.isNullable());
                this.builder.setColumnSize(length);
            } else {
                this.builder.setDataType(OceanBaseUtils.VARCHAR);
                this.builder.setNullable(charType.isNullable());
                this.builder.setColumnSize(Math.min(length, 262144));
            }
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(VarCharType varCharType) {
            int length = varCharType.getLength();
            this.builder.setDataType(OceanBaseUtils.VARCHAR);
            this.builder.setNullable(varCharType.isNullable());
            this.builder.setColumnSize(Math.min(length, 262144));
            if (varCharType.getLength() > 262144) {
                this.builder.setDataType(OceanBaseUtils.TEXT);
                this.builder.setDefaultValue(null);
            }
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(DateType dateType) {
            this.builder.setDataType(OceanBaseUtils.DATE);
            this.builder.setNullable(dateType.isNullable());
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(TimeType timeType) {
            this.builder.setDataType(OceanBaseUtils.TIME);
            this.builder.setNullable(timeType.isNullable());
            this.builder.setColumnSize(Math.min(timeType.getPrecision(), 6));
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(TimestampType timestampType) {
            this.builder.setDataType(OceanBaseUtils.DATETIME);
            this.builder.setNullable(timestampType.isNullable());
            this.builder.setColumnSize(Math.min(timestampType.getPrecision(), 6));
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(ZonedTimestampType zonedTimestampType) {
            this.builder.setDataType(OceanBaseUtils.TIMESTAMP);
            this.builder.setNullable(zonedTimestampType.isNullable());
            this.builder.setColumnSize(Math.min(zonedTimestampType.getPrecision(), 6));
            return this.builder;
        }

        public OceanBaseColumn.Builder visit(LocalZonedTimestampType localZonedTimestampType) {
            this.builder.setDataType(OceanBaseUtils.TIMESTAMP);
            this.builder.setNullable(localZonedTimestampType.isNullable());
            this.builder.setColumnSize(Math.min(localZonedTimestampType.getPrecision(), 6));
            return this.builder;
        }

        protected OceanBaseColumn.Builder defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported CDC data type " + dataType);
        }
    }
}

