/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.sink;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.GenericArrayData;
import org.apache.flink.cdc.common.data.GenericMapData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeChecks;
import org.apache.flink.cdc.common.types.DecimalType;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.types.ZonedTimestampType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class OceanBaseRowConvert
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    static SerializationConverter createNullableExternalConverter(DataType type, ZoneId pipelineZoneId) {
        return OceanBaseRowConvert.wrapIntoNullableExternalConverter(OceanBaseRowConvert.createExternalConverter(type, pipelineZoneId));
    }

    static SerializationConverter wrapIntoNullableExternalConverter(SerializationConverter serializationConverter) {
        return (index, val) -> {
            if (val == null || val.isNullAt(index)) {
                return null;
            }
            return serializationConverter.serialize(index, val);
        };
    }

    static SerializationConverter createExternalConverter(DataType type, ZoneId pipelineZoneId) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (index, val) -> val.getString(index).toString();
            }
            case BOOLEAN: {
                return (index, val) -> val.getBoolean(index);
            }
            case BINARY: 
            case VARBINARY: {
                return (index, val) -> val.getBinary(index);
            }
            case DECIMAL: {
                int decimalPrecision = ((DecimalType)type).getPrecision();
                int decimalScale = ((DecimalType)type).getScale();
                return (index, val) -> val.getDecimal(index, decimalPrecision, decimalScale).toBigDecimal();
            }
            case TINYINT: {
                return (index, val) -> val.getByte(index);
            }
            case SMALLINT: {
                return (index, val) -> val.getShort(index);
            }
            case INTEGER: {
                return (index, val) -> val.getInt(index);
            }
            case BIGINT: {
                return (index, val) -> val.getLong(index);
            }
            case FLOAT: {
                return (index, val) -> Float.valueOf(val.getFloat(index));
            }
            case DOUBLE: {
                return (index, val) -> val.getDouble(index);
            }
            case DATE: {
                return (index, val) -> Date.valueOf(LocalDate.ofEpochDay(val.getInt(index)));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (index, val) -> Time.valueOf(LocalTime.ofSecondOfDay(val.getInt(index) / 1000));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return (index, val) -> val.getTimestamp(index, DataTypeChecks.getPrecision((DataType)type)).toTimestamp();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return (index, val) -> Timestamp.valueOf(ZonedDateTime.ofInstant(val.getLocalZonedTimestampData(index, DataTypeChecks.getPrecision((DataType)type)).toInstant(), pipelineZoneId).toLocalDateTime());
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                int zonedP = ((ZonedTimestampType)type).getPrecision();
                return (index, val) -> val.getTimestamp(index, zonedP).toTimestamp();
            }
            case ARRAY: {
                return (index, val) -> OceanBaseRowConvert.convertArrayData(val.getArray(index), type);
            }
            case MAP: {
                return (index, val) -> OceanBaseRowConvert.writeValueAsString(OceanBaseRowConvert.convertMapData(val.getMap(index), type));
            }
            case ROW: {
                return (index, val) -> OceanBaseRowConvert.writeValueAsString(OceanBaseRowConvert.convertRowData(val, index, type, pipelineZoneId));
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    private static String convertArrayData(ArrayData array, DataType type) {
        if (array instanceof GenericArrayData) {
            return IntStream.range(0, array.size()).mapToObj(i -> array.getString(i).toString()).collect(Collectors.joining(","));
        }
        throw new UnsupportedOperationException("Unsupported array data: " + array.getClass());
    }

    private static Object convertMapData(MapData map, DataType type) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (map instanceof GenericMapData) {
            GenericMapData gMap = (GenericMapData)map;
            for (Object key : ((GenericArrayData)gMap.keyArray()).toObjectArray()) {
                result.put(key, gMap.get(key));
            }
            return result;
        }
        throw new UnsupportedOperationException("Unsupported map data: " + map.getClass());
    }

    private static Object convertRowData(RecordData val, int index, DataType type, ZoneId pipelineZoneId) {
        RowType rowType = (RowType)type;
        HashMap<String, String> value = new HashMap<String, String>();
        RecordData row = val.getRow(index, rowType.getFieldCount());
        List fields = rowType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DataField rowField = (DataField)fields.get(i);
            SerializationConverter converter = OceanBaseRowConvert.createNullableExternalConverter(rowField.getType(), pipelineZoneId);
            Object valTmp = converter.serialize(i, row);
            value.put(rowField.getName(), valTmp.toString());
        }
        return value;
    }

    private static String writeValueAsString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    static interface SerializationConverter
    extends Serializable {
        public Object serialize(int var1, RecordData var2);
    }
}

