/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.sink;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.DropTableEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.event.TruncateTableEvent;
import org.apache.flink.cdc.common.event.visitor.SchemaChangeEventVisitor;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalog;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalogException;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalogFactory;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseColumn;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseTable;
import org.apache.flink.cdc.connectors.oceanbase.sink.OceanBaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseMetadataApplier
implements MetadataApplier {
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseMetadataApplier.class);
    private final OceanBaseCatalog catalog;

    public OceanBaseMetadataApplier(OceanBaseConnectorOptions connectorOptions) {
        try {
            this.catalog = OceanBaseCatalogFactory.createOceanBaseCatalog(connectorOptions);
            this.catalog.open();
        }
        catch (Exception e) {
            throw new OceanBaseCatalogException("Fail to init OceanBaseMetadataApplier.", e);
        }
    }

    public void applySchemaChange(SchemaChangeEvent event) {
        SchemaChangeEventVisitor.visit((SchemaChangeEvent)event, addColumnEvent -> {
            this.applyAddColumnEvent(addColumnEvent);
            return null;
        }, alterColumnTypeEvent -> {
            this.applyAlterColumnTypeEvent(alterColumnTypeEvent);
            return null;
        }, createTableEvent -> {
            this.applyCreateTableEvent(createTableEvent);
            return null;
        }, dropColumnEvent -> {
            this.applyDropColumnEvent(dropColumnEvent);
            return null;
        }, dropTableEvent -> {
            this.applyDropTableEvent(dropTableEvent);
            return null;
        }, renameColumnEvent -> {
            this.applyRenameColumnEvent(renameColumnEvent);
            return null;
        }, truncateTableEvent -> {
            this.applyTruncateTableEvent(truncateTableEvent);
            return null;
        });
    }

    private void applyCreateTableEvent(CreateTableEvent createTableEvent) throws IllegalArgumentException {
        Schema schema = createTableEvent.getSchema();
        TableId tableId = createTableEvent.tableId();
        OceanBaseTable oceanBaseTable = OceanBaseUtils.toOceanBaseTable(tableId, schema);
        if (!this.catalog.databaseExists(oceanBaseTable.getDatabaseName())) {
            this.catalog.createDatabase(oceanBaseTable.getDatabaseName(), true);
        }
        try {
            this.catalog.createTable(oceanBaseTable, true);
            LOG.info("Successful to create table, event: {}", (Object)createTableEvent);
        }
        catch (OceanBaseCatalogException e) {
            LOG.error("Failed to create table, event: {}", (Object)createTableEvent.tableId(), (Object)e);
            throw new RuntimeException("Failed to create table, event: " + createTableEvent, e);
        }
    }

    private void applyAddColumnEvent(AddColumnEvent addColumnEvent) {
        ArrayList<OceanBaseColumn> addColumns = new ArrayList<OceanBaseColumn>();
        for (AddColumnEvent.ColumnWithPosition columnWithPosition : addColumnEvent.getAddedColumns()) {
            Preconditions.checkState((columnWithPosition.getPosition() == AddColumnEvent.ColumnPosition.LAST ? 1 : 0) != 0, (Object)"The oceanbase pipeline connector currently only supports add the column to the last.");
            Column column = columnWithPosition.getAddColumn();
            OceanBaseColumn.Builder builder = new OceanBaseColumn.Builder().setColumnName(column.getName()).setOrdinalPosition(-1).setColumnComment(column.getComment());
            OceanBaseUtils.toOceanBaseDataType(column, false, builder);
            addColumns.add(builder.build());
        }
        TableId tableId = addColumnEvent.tableId();
        this.catalog.alterAddColumns(tableId.getSchemaName(), tableId.getTableName(), addColumns);
    }

    private void applyDropColumnEvent(DropColumnEvent dropColumnEvent) {
        List dropColumns = dropColumnEvent.getDroppedColumnNames();
        this.catalog.alterDropColumns(dropColumnEvent.tableId().getSchemaName(), dropColumnEvent.tableId().getTableName(), dropColumns);
    }

    private void applyAlterColumnTypeEvent(AlterColumnTypeEvent alterColumnTypeEvent) {
        TableId tableId = alterColumnTypeEvent.tableId();
        Map typeMapping = alterColumnTypeEvent.getTypeMapping();
        for (Map.Entry entry : typeMapping.entrySet()) {
            this.catalog.alterColumnType(tableId.getSchemaName(), tableId.getTableName(), (String)entry.getKey(), (DataType)entry.getValue());
        }
    }

    private void applyRenameColumnEvent(RenameColumnEvent renameColumnEvent) {
        TableId tableId = renameColumnEvent.tableId();
        Map nameMapping = renameColumnEvent.getNameMapping();
        for (Map.Entry entry : nameMapping.entrySet()) {
            this.catalog.renameColumn(tableId.getSchemaName(), tableId.getTableName(), (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void applyDropTableEvent(DropTableEvent dropTableEvent) {
        TableId tableId = dropTableEvent.tableId();
        this.catalog.dropTable(tableId.getSchemaName(), tableId.getTableName());
    }

    private void applyTruncateTableEvent(TruncateTableEvent truncateTableEvent) {
        TableId tableId = truncateTableEvent.tableId();
        if (!this.catalog.tableExists(tableId.getSchemaName(), tableId.getTableName())) {
            throw new OceanBaseCatalogException(String.format("Failed to truncate table %s.%s, because the table not exist", tableId.getSchemaName(), tableId.getTableName()));
        }
        this.catalog.truncateTable(tableId.getSchemaName(), tableId.getTableName());
    }
}

