/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.sink;

import java.time.Duration;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.ConfigOptions;

public class OceanBaseDataSinkOptions {
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The connection URL.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("The username.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("The password.");
    public static final ConfigOption<String> DRIVER_CLASS_NAME = ConfigOptions.key((String)"driver-class-name").stringType().defaultValue((Object)"com.mysql.cj.jdbc.Driver").withDescription("JDBC driver class name, use 'com.mysql.cj.jdbc.Driver' by default.");
    public static final ConfigOption<String> DRUID_PROPERTIES = ConfigOptions.key((String)"druid-properties").stringType().noDefaultValue().withDescription("Properties for specific connection pool.");
    public static final ConfigOption<Boolean> MEMSTORE_CHECK_ENABLED = ConfigOptions.key((String)"memstore-check.enabled").booleanType().defaultValue((Object)true).withDescription("Whether enable memstore check. Default value is 'true'");
    public static final ConfigOption<Double> MEMSTORE_THRESHOLD = ConfigOptions.key((String)"memstore-check.threshold").doubleType().defaultValue((Object)0.9).withDescription("Memory usage threshold ratio relative to the limit value. Default value is '0.9'.");
    public static final ConfigOption<Duration> MEMSTORE_CHECK_INTERVAL = ConfigOptions.key((String)"memstore-check.interval").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The check interval, over this time, the writer will check if memstore reaches threshold. Default value is '30s'.");
    public static final ConfigOption<Boolean> PARTITION_ENABLED = ConfigOptions.key((String)"partition.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable partition calculation and flush records by partitions. Default value is 'false'.");
    public static final ConfigOption<Boolean> SYNC_WRITE = ConfigOptions.key((String)"sync-write").booleanType().defaultValue((Object)false).withDescription("Whether to write synchronously.");
    public static final ConfigOption<Duration> BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("The flush interval, over this time, asynchronous threads will flush data. Default value is '1s'. If it's set to zero value like '0', scheduled flushing will be disabled.");
    public static final ConfigOption<Integer> BUFFER_SIZE = ConfigOptions.key((String)"buffer-flush.buffer-size").intType().defaultValue((Object)1000).withDescription("Buffer size. Default value is '1000'.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"max-retries").intType().defaultValue((Object)3).withDescription("The max retry times if writing records to database failed. Default value is '3'.");
}

