/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.sink;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import com.oceanbase.connector.flink.connection.OceanBaseConnectionProvider;
import com.oceanbase.connector.flink.sink.OceanBaseRecordFlusher;
import com.oceanbase.connector.flink.sink.OceanBaseSink;
import com.oceanbase.connector.flink.table.DataChangeRecord;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.sink.DataSink;
import org.apache.flink.cdc.common.sink.EventSinkProvider;
import org.apache.flink.cdc.common.sink.FlinkSinkProvider;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.connectors.oceanbase.sink.OceanBaseEventSerializationSchema;
import org.apache.flink.cdc.connectors.oceanbase.sink.OceanBaseMetadataApplier;

public class OceanBaseDataSink
implements DataSink,
Serializable {
    private final OceanBaseConnectorOptions connectorOptions;
    private final ZoneId zoneId;

    public OceanBaseDataSink(OceanBaseConnectorOptions options, ZoneId zoneId) {
        this.connectorOptions = options;
        this.zoneId = zoneId;
    }

    public EventSinkProvider getEventSinkProvider() {
        OceanBaseConnectionProvider connectionProvider = new OceanBaseConnectionProvider(this.connectorOptions);
        OceanBaseRecordFlusher recordFlusher = new OceanBaseRecordFlusher(this.connectorOptions, connectionProvider);
        return FlinkSinkProvider.of(new OceanBaseSink<Event>(this.connectorOptions, null, new OceanBaseEventSerializationSchema(this.zoneId), DataChangeRecord.KeyExtractor.simple(), recordFlusher));
    }

    public MetadataApplier getMetadataApplier() {
        return new OceanBaseMetadataApplier(this.connectorOptions);
    }
}

