/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.factory;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.factories.DataSinkFactory;
import org.apache.flink.cdc.common.factories.Factory;
import org.apache.flink.cdc.common.pipeline.PipelineOptions;
import org.apache.flink.cdc.common.sink.DataSink;
import org.apache.flink.cdc.connectors.oceanbase.sink.OceanBaseDataSink;
import org.apache.flink.cdc.connectors.oceanbase.sink.OceanBaseDataSinkOptions;
import org.apache.flink.cdc.connectors.oceanbase.utils.OptionUtils;

@Internal
public class OceanBaseDataSinkFactory
implements DataSinkFactory {
    private static final String IDENTIFIER = "oceanbase";

    public DataSink createDataSink(Factory.Context context) {
        Configuration config = context.getFactoryConfiguration();
        Map configMap = config.toMap();
        OptionUtils.printOptions(IDENTIFIER, configMap);
        OceanBaseConnectorOptions connectorOptions = new OceanBaseConnectorOptions(configMap);
        String zoneStr = (String)context.getPipelineConfiguration().get(PipelineOptions.PIPELINE_LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)PipelineOptions.PIPELINE_LOCAL_TIME_ZONE.defaultValue()).equals(zoneStr) ? ZoneId.systemDefault() : ZoneId.of(zoneStr);
        return new OceanBaseDataSink(connectorOptions, zoneId);
    }

    public String identifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(OceanBaseDataSinkOptions.URL);
        requiredOptions.add(OceanBaseDataSinkOptions.USERNAME);
        requiredOptions.add(OceanBaseDataSinkOptions.PASSWORD);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(OceanBaseDataSinkOptions.DRIVER_CLASS_NAME);
        optionalOptions.add(OceanBaseDataSinkOptions.DRUID_PROPERTIES);
        optionalOptions.add(OceanBaseDataSinkOptions.MEMSTORE_CHECK_ENABLED);
        optionalOptions.add(OceanBaseDataSinkOptions.MEMSTORE_THRESHOLD);
        optionalOptions.add(OceanBaseDataSinkOptions.MEMSTORE_CHECK_INTERVAL);
        optionalOptions.add(OceanBaseDataSinkOptions.PARTITION_ENABLED);
        optionalOptions.add(OceanBaseDataSinkOptions.SYNC_WRITE);
        optionalOptions.add(OceanBaseDataSinkOptions.BUFFER_FLUSH_INTERVAL);
        optionalOptions.add(OceanBaseDataSinkOptions.BUFFER_SIZE);
        optionalOptions.add(OceanBaseDataSinkOptions.MAX_RETRIES);
        return optionalOptions;
    }
}

