/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseColumn;
import org.apache.flink.util.Preconditions;

public class OceanBaseTable {
    private final String databaseName;
    private final String tableName;
    private final TableType tableType;
    private final List<OceanBaseColumn> columns;
    @Nullable
    private final List<String> tableKeys;
    private final List<String> partitionKeys;
    @Nullable
    private final String comment;
    private final Map<String, String> properties;
    @Nullable
    private volatile Map<String, OceanBaseColumn> columnMap;

    private OceanBaseTable(String databaseName, String tableName, TableType tableType, List<OceanBaseColumn> columns, @Nullable List<String> tableKeys, @Nullable List<String> partitionKeys, @Nullable String comment, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)databaseName);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)((Object)tableType));
        Preconditions.checkArgument((columns != null && !columns.isEmpty() ? 1 : 0) != 0);
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.columns = columns;
        this.tableKeys = tableKeys;
        this.partitionKeys = partitionKeys;
        this.comment = comment;
        this.properties = (Map)Preconditions.checkNotNull(properties);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public List<OceanBaseColumn> getColumns() {
        return this.columns;
    }

    public Optional<List<String>> getTableKeys() {
        return Optional.ofNullable(this.tableKeys);
    }

    public Optional<List<String>> getPartitionKeys() {
        return Optional.ofNullable(this.partitionKeys);
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OceanBaseColumn getColumn(String columnName) {
        if (this.columnMap == null) {
            OceanBaseTable oceanBaseTable = this;
            synchronized (oceanBaseTable) {
                if (this.columnMap == null) {
                    this.columnMap = new HashMap<String, OceanBaseColumn>();
                    for (OceanBaseColumn column : this.columns) {
                        this.columnMap.put(column.getColumnName(), column);
                    }
                }
            }
        }
        return this.columnMap.get(columnName);
    }

    public String toString() {
        return "OceanBaseTable{databaseName='" + this.databaseName + '\'' + ", tableName='" + this.tableName + '\'' + ", tableType=" + (Object)((Object)this.tableType) + ", columns=" + this.columns + ", tableKeys=" + this.tableKeys + ", partitionKeys=" + this.partitionKeys + ", comment='" + this.comment + '\'' + ", properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OceanBaseTable that = (OceanBaseTable)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && this.tableType == that.tableType && Objects.equals(this.columns, that.columns) && Objects.equals(this.tableKeys, that.tableKeys) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.comment, that.comment) && Objects.equals(this.properties, that.properties);
    }

    public static class Builder {
        private String databaseName;
        private String tableName;
        private TableType tableType;
        private List<OceanBaseColumn> columns = new ArrayList<OceanBaseColumn>();
        private List<String> tableKeys;
        private List<String> partitionKeys;
        private String comment;
        private Map<String, String> properties = new HashMap<String, String>();

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setTableType(TableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public Builder setColumns(List<OceanBaseColumn> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setTableKeys(List<String> tableKeys) {
            this.tableKeys = tableKeys;
            return this;
        }

        public Builder setPartitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setTableProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public OceanBaseTable build() {
            return new OceanBaseTable(this.databaseName, this.tableName, this.tableType, this.columns, this.tableKeys, this.partitionKeys, this.comment, this.properties);
        }
    }

    public static enum TableType {
        UNKNOWN,
        DUPLICATE_KEY,
        PRIMARY_KEY;

    }
}

