/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.catalog;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeVisitor;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalog;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalogException;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseColumn;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseTable;
import org.apache.flink.cdc.connectors.oceanbase.sink.OceanBaseUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseMySQLCatalog
extends OceanBaseCatalog {
    private static final String RENAME_DDL = "ALTER TABLE `%s`.`%s` RENAME COLUMN `%s` TO `%s`";
    private static final String ALTER_COLUMN_TYPE_DDL = "ALTER TABLE `%s`.`%s` MODIFY COLUMN `%s` %s;";
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseMySQLCatalog.class);

    public OceanBaseMySQLCatalog(OceanBaseConnectorOptions connectorOptions) {
        super(connectorOptions);
    }

    @Override
    public boolean databaseExists(String databaseName) throws OceanBaseCatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        String querySql = String.format("SELECT `SCHEMA_NAME` FROM `INFORMATION_SCHEMA`.`SCHEMATA` WHERE SCHEMA_NAME = '%s';", databaseName);
        try {
            List<String> dbList = this.executeSingleColumnStatement(querySql);
            return !dbList.isEmpty();
        }
        catch (Exception e) {
            LOG.error("Failed to check database exist, database: {}, sql: {}", new Object[]{databaseName, querySql, e});
            throw new OceanBaseCatalogException(String.format("Failed to check database exist, database: %s", databaseName), e);
        }
    }

    @Override
    public void createDatabase(String databaseName, boolean ignoreIfExists) throws OceanBaseCatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        String sql = this.buildCreateDatabaseSql(databaseName, ignoreIfExists);
        try {
            this.executeUpdateStatement(sql);
            LOG.info("Successful to create database {}, sql: {}", (Object)databaseName, (Object)sql);
        }
        catch (Exception e) {
            LOG.info("Failed to create database {}, sql: {}", new Object[]{databaseName, sql, e});
            throw new OceanBaseCatalogException(String.format("Failed to create database %s, ignoreIfExists: %s", databaseName, ignoreIfExists), e);
        }
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws OceanBaseCatalogException {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)tableName) ? 1 : 0) != 0, (Object)"table name cannot be null or empty.");
        String querySql = String.format("SELECT `TABLE_NAME` FROM `INFORMATION_SCHEMA`.`TABLES` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s';", databaseName, tableName);
        try {
            List<String> dbList = this.executeSingleColumnStatement(querySql);
            return !dbList.isEmpty();
        }
        catch (Exception e) {
            LOG.error("Failed to check table exist, table: {}, sql: {}", new Object[]{tableName, querySql, e});
            throw new OceanBaseCatalogException(String.format("Failed to check table exist, table: %s", tableName), e);
        }
    }

    @Override
    public void createTable(OceanBaseTable table, boolean ignoreIfExists) throws OceanBaseCatalogException {
        String createTableSql = this.buildCreateTableSql(table, ignoreIfExists);
        try {
            this.executeUpdateStatement(createTableSql);
            LOG.info("Success to create table {}.{}, sql: {}", new Object[]{table.getDatabaseName(), table.getDatabaseName(), createTableSql});
        }
        catch (Exception e) {
            LOG.error("Failed to create table {}.{}, sql: {}", new Object[]{table.getDatabaseName(), table.getDatabaseName(), createTableSql, e});
            throw new OceanBaseCatalogException(String.format("Failed to create table %s.%s", table.getDatabaseName(), table.getDatabaseName()), e);
        }
    }

    @Override
    public void alterAddColumns(String databaseName, String tableName, List<OceanBaseColumn> addColumns) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)tableName) ? 1 : 0) != 0, (Object)"table name cannot be null or empty.");
        Preconditions.checkArgument((!addColumns.isEmpty() ? 1 : 0) != 0, (Object)"Added columns should not be empty.");
        String alterSql = this.buildAlterAddColumnsSql(databaseName, tableName, addColumns);
        try {
            long startTimeMillis = System.currentTimeMillis();
            this.executeUpdateStatement(alterSql);
            LOG.info("Success to add columns to {}.{}, duration: {}ms, sql: {}", new Object[]{databaseName, tableName, System.currentTimeMillis() - startTimeMillis, alterSql});
        }
        catch (Exception e) {
            LOG.error("Failed to add columns to {}.{}, sql: {}", new Object[]{databaseName, tableName, alterSql, e});
            throw new OceanBaseCatalogException(String.format("Failed to add columns to %s.%s ", databaseName, tableName), e);
        }
    }

    @Override
    public void alterDropColumns(String databaseName, String tableName, List<String> dropColumns) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)tableName) ? 1 : 0) != 0, (Object)"table name cannot be null or empty.");
        Preconditions.checkArgument((!dropColumns.isEmpty() ? 1 : 0) != 0, (Object)"Drop columns should not be empty.");
        String alterSql = this.buildAlterDropColumnsSql(databaseName, tableName, dropColumns);
        try {
            long startTimeMillis = System.currentTimeMillis();
            this.executeUpdateStatement(alterSql);
            LOG.info("Success to drop columns from {}.{}, duration: {}ms, sql: {}", new Object[]{databaseName, tableName, System.currentTimeMillis() - startTimeMillis, alterSql});
        }
        catch (Exception e) {
            LOG.error("Failed to drop columns from {}.{}, sql: {}", new Object[]{databaseName, tableName, alterSql});
            throw new OceanBaseCatalogException(String.format("Failed to drop columns from %s.%s ", databaseName, tableName), e);
        }
    }

    @Override
    public void alterColumnType(String databaseName, String tableName, String columnName, DataType dataType) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)tableName) ? 1 : 0) != 0, (Object)"table name cannot be null or empty.");
        OceanBaseUtils.CdcDataTypeTransformer cdcDataTypeTransformer = new OceanBaseUtils.CdcDataTypeTransformer(false, new OceanBaseColumn.Builder());
        OceanBaseColumn oceanBaseColumn = ((OceanBaseColumn.Builder)dataType.accept((DataTypeVisitor)cdcDataTypeTransformer)).setColumnName(columnName).build();
        String alterTypeSql = String.format(ALTER_COLUMN_TYPE_DDL, databaseName, tableName, columnName, oceanBaseColumn.getDataType());
        try {
            long startTimeMillis = System.currentTimeMillis();
            this.executeUpdateStatement(alterTypeSql);
            LOG.info("Success to alter table {}.{} column {} to type {}, duration: {}ms, sql: {}", new Object[]{databaseName, tableName, columnName, oceanBaseColumn.getDataType(), System.currentTimeMillis() - startTimeMillis, alterTypeSql});
        }
        catch (Exception e) {
            LOG.error("Failed to alter table {}.{} column {} to type {}, sql: {}", new Object[]{databaseName, tableName, columnName, oceanBaseColumn.getDataType(), alterTypeSql, e});
            throw new OceanBaseCatalogException(String.format("Failed to alter table %s.%s column %s to type %s ", databaseName, tableName, columnName, oceanBaseColumn.getDataType()), e);
        }
    }

    @Override
    public void renameColumn(String schemaName, String tableName, String oldColumnName, String newColumnName) {
        String renameColumnSql = OceanBaseMySQLCatalog.buildRenameColumnSql(schemaName, tableName, oldColumnName, newColumnName);
        try {
            long startTimeMillis = System.currentTimeMillis();
            this.executeUpdateStatement(renameColumnSql);
            LOG.info("Success to rename {} column from {} to {}, duration: {}ms, sql: {}", new Object[]{String.format("%s.%s", schemaName, tableName), oldColumnName, newColumnName, System.currentTimeMillis() - startTimeMillis, renameColumnSql});
        }
        catch (Exception e) {
            LOG.error("Fail to rename {} column from {} to {}, duration: {}ms, sql: {}", new Object[]{String.format("%s.%s", schemaName, tableName), oldColumnName, newColumnName, renameColumnSql, e});
            throw new OceanBaseCatalogException(String.format("Failed to rename %s column from %s to %s ", String.format("%s.%s", schemaName, tableName), schemaName, tableName), e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)tableName) ? 1 : 0) != 0, (Object)"table name cannot be null or empty.");
        String dropTableDDL = String.format("DROP TABLE IF EXISTS `%s`.`%s`", databaseName, tableName);
        try {
            long startTimeMillis = System.currentTimeMillis();
            this.executeUpdateStatement(dropTableDDL);
            LOG.info("Success to drop table {}.{}, duration: {}ms, sql: {}", new Object[]{databaseName, tableName, System.currentTimeMillis() - startTimeMillis, dropTableDDL});
        }
        catch (Exception e) {
            LOG.error("Failed to drop table {}.{}, sql: {}", new Object[]{databaseName, tableName, dropTableDDL, e});
            throw new OceanBaseCatalogException(String.format("Failed to drop table %s.%s ", databaseName, tableName), e);
        }
    }

    @Override
    public void truncateTable(String databaseName, String tableName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"database name cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)tableName) ? 1 : 0) != 0, (Object)"table name cannot be null or empty.");
        String dropTableDDL = String.format("TRUNCATE TABLE `%s`.`%s`", databaseName, tableName);
        try {
            long startTimeMillis = System.currentTimeMillis();
            this.executeUpdateStatement(dropTableDDL);
            LOG.info("Success to truncate table {}.{}, duration: {}ms, sql: {}", new Object[]{databaseName, tableName, System.currentTimeMillis() - startTimeMillis, dropTableDDL});
        }
        catch (Exception e) {
            LOG.error("Failed to truncate table {}.{}, sql: {}", new Object[]{databaseName, tableName, dropTableDDL, e});
            throw new OceanBaseCatalogException(String.format("Failed to truncate table %s.%s ", databaseName, tableName), e);
        }
    }

    protected String buildCreateDatabaseSql(String databaseName, boolean ignoreIfExists) {
        return String.format("CREATE DATABASE %s%s;", ignoreIfExists ? "IF NOT EXISTS " : "", databaseName);
    }

    protected String buildCreateTableSql(OceanBaseTable table, boolean ignoreIfExists) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("CREATE TABLE %s`%s`.`%s`", ignoreIfExists ? "IF NOT EXISTS " : "", table.getDatabaseName(), table.getTableName()));
        builder.append(" (\n");
        String columnsStmt = table.getColumns().stream().map(this::buildColumnStmt).collect(Collectors.joining(",\n"));
        builder.append(columnsStmt);
        builder.append(",\n");
        String tableKeys = table.getTableKeys().get().stream().map(key -> "`" + key + "`").collect(Collectors.joining(", "));
        builder.append(String.format("PRIMARY KEY (%s)", tableKeys));
        builder.append("\n) ");
        if (!table.getProperties().isEmpty()) {
            builder.append("\nPROPERTIES (\n");
            String properties = table.getProperties().entrySet().stream().map(entry -> String.format("\"%s\" = \"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n"));
            builder.append(properties);
            builder.append("\n)");
        }
        builder.append(";");
        return builder.toString();
    }

    private String buildAlterDropColumnsSql(String databaseName, String tableName, List<String> dropColumns) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("ALTER TABLE `%s`.`%s` ", databaseName, tableName));
        String columnsStmt = dropColumns.stream().map(col -> String.format("DROP COLUMN `%s`", col)).collect(Collectors.joining(", "));
        builder.append(columnsStmt);
        builder.append(";");
        return builder.toString();
    }

    protected String buildColumnStmt(OceanBaseColumn column) {
        StringBuilder builder = new StringBuilder();
        builder.append("`");
        builder.append(column.getColumnName());
        builder.append("` ");
        builder.append(this.getFullColumnType(column.getDataType(), column.getColumnSize(), column.getNumericScale()));
        builder.append(" ");
        builder.append(column.isNullable() ? "NULL" : "NOT NULL");
        if (column.getDefaultValue().isPresent()) {
            builder.append(String.format(" DEFAULT \"%s\"", column.getDefaultValue().get()));
        }
        if (column.getColumnComment().isPresent()) {
            builder.append(String.format(" COMMENT \"%s\"", column.getColumnComment().get()));
        }
        return builder.toString();
    }

    protected String getFullColumnType(String type, Optional<Integer> columnSize, Optional<Integer> decimalDigits) {
        String dataType;
        switch (dataType = type.toUpperCase()) {
            case "DECIMAL": {
                Preconditions.checkArgument((boolean)columnSize.isPresent(), (Object)"DECIMAL type must have column size");
                Preconditions.checkArgument((boolean)decimalDigits.isPresent(), (Object)"DECIMAL type must have decimal digits");
                return String.format("DECIMAL(%d, %s)", columnSize.get(), decimalDigits.get());
            }
            case "CHAR": 
            case "VARCHAR": 
            case "VARBINARY": {
                Preconditions.checkArgument((boolean)columnSize.isPresent(), (Object)(type + " type must have column size"));
                return String.format("%s(%d)", dataType, columnSize.get());
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return columnSize.map(size -> String.format("%s(%d)", dataType, size)).orElse(dataType);
            }
        }
        return dataType;
    }

    protected String buildAlterAddColumnsSql(String databaseName, String tableName, List<OceanBaseColumn> addColumns) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("ALTER TABLE `%s`.`%s` ", databaseName, tableName));
        String columnsStmt = addColumns.stream().map(col -> "ADD COLUMN " + this.buildColumnStmt((OceanBaseColumn)col)).collect(Collectors.joining(", "));
        builder.append(columnsStmt);
        builder.append(";");
        return builder.toString();
    }

    private static String buildRenameColumnSql(String schemaName, String tableName, String oldColumnName, String newColumnName) {
        return String.format(RENAME_DDL, schemaName, tableName, oldColumnName, newColumnName);
    }
}

