/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.catalog;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class OceanBaseColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final int ordinalPosition;
    private final String dataType;
    private final boolean isNullable;
    @Nullable
    private final String defaultValue;
    @Nullable
    private final Integer columnSize;
    @Nullable
    private final Integer numericScale;
    @Nullable
    private final String columnComment;

    private OceanBaseColumn(String columnName, int ordinalPosition, String dataType, boolean isNullable, @Nullable String defaultValue, @Nullable Integer columnSize, @Nullable Integer numericScale, @Nullable String columnComment) {
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName);
        this.ordinalPosition = ordinalPosition;
        this.dataType = (String)Preconditions.checkNotNull((Object)dataType);
        this.isNullable = isNullable;
        this.defaultValue = defaultValue;
        this.columnSize = columnSize;
        this.numericScale = numericScale;
        this.columnComment = columnComment;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public Optional<Integer> getColumnSize() {
        return Optional.ofNullable(this.columnSize);
    }

    public Optional<Integer> getNumericScale() {
        return Optional.ofNullable(this.numericScale);
    }

    public Optional<String> getColumnComment() {
        return Optional.ofNullable(this.columnComment);
    }

    public String toString() {
        return "OceanBaseColumn{columnName='" + this.columnName + '\'' + ", ordinalPosition=" + this.ordinalPosition + ", dataType='" + this.dataType + '\'' + ", isNullable=" + this.isNullable + ", defaultValue='" + this.defaultValue + '\'' + ", columnSize=" + this.columnSize + ", numericScale=" + this.numericScale + ", columnComment='" + this.columnComment + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OceanBaseColumn column = (OceanBaseColumn)o;
        return this.ordinalPosition == column.ordinalPosition && this.isNullable == column.isNullable && Objects.equals(this.columnName, column.columnName) && this.dataType.equalsIgnoreCase(column.dataType) && Objects.equals(this.defaultValue, column.defaultValue) && Objects.equals(this.columnSize, column.columnSize) && Objects.equals(this.numericScale, column.numericScale) && Objects.equals(this.columnComment, column.columnComment);
    }

    public static class Builder {
        private String columnName;
        private int ordinalPosition;
        private String dataType;
        private boolean isNullable = true;
        private String defaultValue;
        private Integer columnSize;
        private Integer numericScale;
        private String columnComment;

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setOrdinalPosition(int ordinalPosition) {
            this.ordinalPosition = ordinalPosition;
            return this;
        }

        public Builder setDataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setColumnSize(Integer columnSize) {
            this.columnSize = columnSize;
            return this;
        }

        public Builder setNumericScale(Integer numericScale) {
            this.numericScale = numericScale;
            return this;
        }

        public Builder setColumnComment(String columnComment) {
            this.columnComment = columnComment;
            return this;
        }

        public OceanBaseColumn build() {
            return new OceanBaseColumn(this.columnName, this.ordinalPosition, this.dataType, this.isNullable, this.defaultValue, this.columnSize, this.numericScale, this.columnComment);
        }
    }
}

