/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.catalog;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import com.oceanbase.connector.flink.connection.OceanBaseConnectionProvider;
import com.oceanbase.connector.flink.dialect.OceanBaseDialect;
import com.oceanbase.connector.flink.dialect.OceanBaseMySQLDialect;
import com.oceanbase.connector.flink.dialect.OceanBaseOracleDialect;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalog;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalogException;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseMySQLCatalog;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseOracleCatalog;

public class OceanBaseCatalogFactory {
    public static OceanBaseCatalog createOceanBaseCatalog(OceanBaseConnectorOptions connectorOptions) throws Exception {
        Throwable throwable = null;
        try (OceanBaseConnectionProvider connectionProvider = new OceanBaseConnectionProvider(connectorOptions);){
            OceanBaseDialect dialect = connectionProvider.getDialect();
            if (dialect instanceof OceanBaseMySQLDialect) {
                OceanBaseMySQLCatalog oceanBaseMySQLCatalog = new OceanBaseMySQLCatalog(connectorOptions);
                return oceanBaseMySQLCatalog;
            }
            if (dialect instanceof OceanBaseOracleDialect) {
                OceanBaseOracleCatalog oceanBaseOracleCatalog = new OceanBaseOracleCatalog(connectorOptions);
                return oceanBaseOracleCatalog;
            }
            try {
                throw new OceanBaseCatalogException("Fail to create OceanBaseCatalog: unknown tenant.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

