/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.catalog;

import com.oceanbase.connector.flink.OceanBaseConnectorOptions;
import com.oceanbase.connector.flink.connection.OceanBaseConnectionProvider;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseCatalogException;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseColumn;
import org.apache.flink.cdc.connectors.oceanbase.catalog.OceanBaseTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OceanBaseCatalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseCatalog.class);
    protected OceanBaseConnectionProvider connectionProvider;
    private final OceanBaseConnectorOptions connectorOptions;

    public OceanBaseCatalog(OceanBaseConnectorOptions connectorOptions) {
        assert (Objects.nonNull(connectorOptions));
        this.connectorOptions = connectorOptions;
    }

    public void open() {
        this.connectionProvider = new OceanBaseConnectionProvider(this.connectorOptions);
        LOG.info("Open OceanBase catalog");
    }

    /*
     * Exception decompiling
     */
    protected List<String> executeSingleColumnStatement(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void executeUpdateStatement(String sql) throws SQLException {
        try (Connection connection = this.connectionProvider.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
    }

    public abstract boolean databaseExists(String var1) throws OceanBaseCatalogException;

    public abstract void createDatabase(String var1, boolean var2) throws OceanBaseCatalogException;

    public abstract boolean tableExists(String var1, String var2) throws OceanBaseCatalogException;

    public abstract void createTable(OceanBaseTable var1, boolean var2) throws OceanBaseCatalogException;

    public abstract void alterAddColumns(String var1, String var2, List<OceanBaseColumn> var3);

    public abstract void alterDropColumns(String var1, String var2, List<String> var3);

    public abstract void alterColumnType(String var1, String var2, String var3, DataType var4);

    public abstract void renameColumn(String var1, String var2, String var3, String var4);

    public abstract void dropTable(String var1, String var2);

    public abstract void truncateTable(String var1, String var2);

    public void close() {
        LOG.info("Close OceanBase catalog");
    }
}

