/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.struct;

import com.oceanbase.partition.calculator.struct.ObCommonStruct;
import com.oceanbase.partition.calculator.utils.ObHashUtils;
import java.math.BigInteger;

public class ObIntervalYmValue
extends ObCommonStruct {
    private static final long serialVersionUID = 7662013165238530193L;
    private static final long MONTHS_IN_YEAR = 12L;
    private long nmonth;

    public ObIntervalYmValue(Object intervalYmObj) {
        if (intervalYmObj == null) {
            return;
        }
        String intervalYm = intervalYmObj.toString().trim();
        int[] parts = new int[]{0, 0};
        StringBuilder sb = new StringBuilder(4);
        int index = 0;
        int length = intervalYm.length();
        int seed = 1;
        for (int i = 0; i < length; ++i) {
            char ch = intervalYm.charAt(i);
            if (i == 0 && (ch == '-' || ch == '+')) {
                if (ch != '-') continue;
                seed = -1;
                continue;
            }
            if (ch != '-' || i == length - 1) {
                sb.append(ch);
            }
            if (ch != '-' && i != length - 1) continue;
            parts[index++] = Integer.parseInt(sb.toString());
            sb.setLength(0);
        }
        int years = parts[0];
        int month = parts[1];
        this.nmonth = (long)seed * ((long)years * 12L + (long)month);
    }

    @Override
    public BigInteger murmurhash64A(BigInteger hashSeed) {
        BigInteger hashCode = hashSeed;
        hashCode = ObHashUtils.longHash(this.getNmonth(), hashCode);
        return hashCode;
    }

    public long getNmonth() {
        return this.nmonth;
    }
}

