/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.model.ObReplicaType;
import com.oceanbase.partition.calculator.model.ObServerAddr;
import com.oceanbase.partition.calculator.model.ObServerRole;
import java.util.Objects;

public class ReplicaLocation
implements Comparable<ReplicaLocation> {
    private ObServerAddr addr;
    private ObServerRole role;
    private ObReplicaType replicaType;

    public ReplicaLocation() {
        this.addr = null;
        this.role = ObServerRole.INVALID_ROLE;
        this.replicaType = ObReplicaType.INVALID;
    }

    public ReplicaLocation(ObServerRole role, ObServerAddr addr, ObReplicaType replicaType) {
        this.role = role;
        this.addr = addr;
        this.replicaType = replicaType;
    }

    public ReplicaLocation(ReplicaLocation replica) {
        this.role = replica.getRole();
        this.addr = replica.getAddr();
        this.replicaType = replica.getReplicaType();
    }

    public boolean isValid() {
        return this.addr != null && this.addr.isValid() && ObServerRole.INVALID_ROLE != this.role && ObReplicaType.INVALID != this.replicaType;
    }

    public boolean isLeader() {
        return this.isValid() && ObServerRole.LEADER == this.role;
    }

    public boolean isFollower() {
        return this.isValid() && ObServerRole.FOLLOWER == this.role;
    }

    public boolean isAddrEqual(ReplicaLocation other) {
        return this.addr != null && other != null && this.addr.equals(other.addr);
    }

    public boolean isReadOnly() {
        return ObReplicaType.READONLY == this.replicaType;
    }

    public boolean isWeakReadAvail() {
        return this.isReadOnly() || ObReplicaType.FULL == this.replicaType;
    }

    public boolean isWeakReadAvailFollower() {
        return ObServerRole.FOLLOWER == this.role && this.isWeakReadAvail();
    }

    @Override
    public int compareTo(ReplicaLocation o) {
        return o == null ? 0 : this.addr.compareTo(o.addr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaLocation [");
        sb.append("Role: ").append((Object)this.getRole());
        sb.append(", Addr: ").append(this.getAddr());
        sb.append(", ReplicaType: ").append((Object)this.getReplicaType());
        return sb.append("]").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result *= 31 * result + (this.addr == null ? 0 : this.addr.hashCode());
        result *= 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result *= 31 * result + (this.replicaType == null ? 0 : this.replicaType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicaLocation other = (ReplicaLocation)obj;
        return Objects.deepEquals(this.getAddr(), other.getAddr()) && Objects.deepEquals((Object)this.getRole(), (Object)other.getRole()) && Objects.deepEquals((Object)this.getReplicaType(), (Object)other.getReplicaType());
    }

    public ObServerAddr getAddr() {
        return this.addr;
    }

    public void setAddr(ObServerAddr addr) {
        this.addr = addr;
    }

    public ObServerRole getRole() {
        return this.role;
    }

    public void setRole(ObServerRole role) {
        this.role = role;
    }

    public ObReplicaType getReplicaType() {
        return this.replicaType;
    }

    public void setReplicaType(ObReplicaType replicaType) {
        this.replicaType = replicaType;
    }
}

