/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public final class ObServerRole
extends Enum<ObServerRole> {
    public static final /* enum */ ObServerRole INVALID_ROLE;
    public static final /* enum */ ObServerRole LEADER;
    public static final /* enum */ ObServerRole FOLLOWER;
    private static final Map<Integer, ObServerRole> INDEX_MAPPING;
    private static final Map<String, ObServerRole> NAME_MAPPING;
    private final String name;
    private final int index;
    private static final /* synthetic */ ObServerRole[] $VALUES;

    public static ObServerRole[] values() {
        return (ObServerRole[])$VALUES.clone();
    }

    public static ObServerRole valueOf(String name) {
        return Enum.valueOf(ObServerRole.class, name);
    }

    private ObServerRole(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static ObServerRole getRole(int index) {
        return INDEX_MAPPING.getOrDefault(index, INVALID_ROLE);
    }

    public static ObServerRole getRole(@NonNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        String upper = role.toUpperCase(Locale.getDefault());
        return NAME_MAPPING.getOrDefault(upper, INVALID_ROLE);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    static {
        ObServerRole[] obServerRoles;
        INVALID_ROLE = new ObServerRole("INVALID_ROLE", 0);
        LEADER = new ObServerRole("LEADER", 1);
        FOLLOWER = new ObServerRole("FOLLOWER", 2);
        $VALUES = new ObServerRole[]{INVALID_ROLE, LEADER, FOLLOWER};
        INDEX_MAPPING = new HashMap<Integer, ObServerRole>(3);
        NAME_MAPPING = new HashMap<String, ObServerRole>(3);
        for (ObServerRole obServerRole : obServerRoles = ObServerRole.values()) {
            NAME_MAPPING.putIfAbsent(obServerRole.getName(), obServerRole);
            INDEX_MAPPING.putIfAbsent(obServerRole.getIndex(), obServerRole);
        }
    }
}

