/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.model.ObDataTypeEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ObDataTypeNode {
    private long dataSourceId;
    private String typeName;
    private String typeOwner;
    private ObDataTypeEnum typeEnum;
    private List<ObDataTypeNode> childNodes;

    public ObDataTypeNode(long datasoureId, String typeName, String typeOwner, String type) {
        this.dataSourceId = datasoureId;
        this.typeName = typeName;
        this.typeOwner = typeOwner;
        this.typeEnum = ObDataTypeEnum.getDataTypeEnum(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNode(ObDataTypeNode childNode) {
        ObDataTypeNode obDataTypeNode = this;
        synchronized (obDataTypeNode) {
            if (null == this.childNodes) {
                this.childNodes = new ArrayList<ObDataTypeNode>();
            }
            this.childNodes.add(childNode);
        }
    }

    public boolean isUserDefinedType() {
        return !ObDataTypeEnum.isBasicDataType(this.typeName);
    }

    public boolean hasChildNodes() {
        return CollectionUtils.isNotEmpty(this.childNodes);
    }

    public ObDataTypeNode getChildNodeByIndex(int index) {
        return this.childNodes.get(index);
    }

    public int getChildrenCount() {
        return this.childNodes == null ? 0 : this.childNodes.size();
    }

    public long getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(long dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeOwner() {
        return this.typeOwner;
    }

    public void setTypeOwner(String typeOwner) {
        this.typeOwner = typeOwner;
    }

    public ObDataTypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(ObDataTypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public List<ObDataTypeNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<ObDataTypeNode> childNodes) {
        this.childNodes = childNodes;
    }
}

