/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class ObDataTypeEnum
extends Enum<ObDataTypeEnum> {
    public static final /* enum */ ObDataTypeEnum STRING;
    public static final /* enum */ ObDataTypeEnum INTEGER;
    public static final /* enum */ ObDataTypeEnum ARRAY;
    public static final /* enum */ ObDataTypeEnum OBJECT;
    public static final /* enum */ ObDataTypeEnum INVALID;
    public static final /* enum */ ObDataTypeEnum COLLECTION;
    private static final Map<String, ObDataTypeEnum> NAME_MAPPING;
    private final String type;
    private static final /* synthetic */ ObDataTypeEnum[] $VALUES;

    public static ObDataTypeEnum[] values() {
        return (ObDataTypeEnum[])$VALUES.clone();
    }

    public static ObDataTypeEnum valueOf(String name) {
        return Enum.valueOf(ObDataTypeEnum.class, name);
    }

    private ObDataTypeEnum(String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type.toUpperCase();
    }

    public static ObDataTypeEnum getDataTypeEnum(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String upper = type.toUpperCase();
        return NAME_MAPPING.getOrDefault(upper, INVALID);
    }

    public static boolean isBasicDataType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        String upper = type.toUpperCase();
        return ObDataTypeEnum.INTEGER.type.equals(upper) || ObDataTypeEnum.STRING.type.equals(upper);
    }

    public String getType() {
        return this.type;
    }

    static {
        ObDataTypeEnum[] obDataTypeEnums;
        STRING = new ObDataTypeEnum("STRING");
        INTEGER = new ObDataTypeEnum("INTEGER");
        ARRAY = new ObDataTypeEnum("ARRAY");
        OBJECT = new ObDataTypeEnum("OBJECT");
        INVALID = new ObDataTypeEnum("INVALID");
        COLLECTION = new ObDataTypeEnum("COLLECTION");
        $VALUES = new ObDataTypeEnum[]{STRING, INTEGER, ARRAY, OBJECT, INVALID, COLLECTION};
        NAME_MAPPING = new HashMap<String, ObDataTypeEnum>(6);
        for (ObDataTypeEnum obDataTypeEnum : obDataTypeEnums = ObDataTypeEnum.values()) {
            NAME_MAPPING.putIfAbsent(obDataTypeEnum.getType(), obDataTypeEnum);
        }
    }
}

