/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.function.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.oceanbase.partition.calculator.constants.Constants;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Year
implements Function {
    private static final Logger log = LoggerFactory.getLogger(Year.class);
    public static final Year instance = new Year();

    private Year() {
    }

    @Override
    public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        if (x.getArguments().size() != 1) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        SQLExpr expr = x.getArguments().get(0);
        expr.accept(visitor);
        Object result = expr.getAttributes().get("eval.value");
        if (result == null) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        try {
            Date date;
            Instant instant;
            int year;
            String datetime = result.toString();
            int index = datetime.indexOf(46);
            if (index > -1) {
                int scale = datetime.length() - index;
                if (scale == 1) {
                    datetime = datetime.substring(0, index);
                } else if (scale > 3) {
                    datetime = datetime.substring(0, index + 2);
                }
            }
            return (year = LocalDateTime.ofInstant(instant = Instant.ofEpochMilli((date = DateUtils.parseDate((String)datetime, (String[])Constants.DEFAULT_PARSE_PATTERNS)).getTime()), ZoneId.systemDefault()).getYear()) < 1 ? 0 : year;
        }
        catch (ParseException e) {
            log.error("Invoke {} failed. Error: {}", (Object)x.toString(), (Object)e.getMessage());
            return SQLEvalVisitor.EVAL_ERROR;
        }
    }
}

